/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.serial;

import com.serotonin.modbus4j.ModbusMaster;
import com.serotonin.modbus4j.exception.ModbusInitException;
import com.serotonin.modbus4j.serial.SerialPortWrapper;
import com.serotonin.modbus4j.sero.messaging.EpollStreamTransport;
import com.serotonin.modbus4j.sero.messaging.MessageControl;
import com.serotonin.modbus4j.sero.messaging.StreamTransport;
import com.serotonin.modbus4j.sero.messaging.Transport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SerialMaster
extends ModbusMaster {
    private static final int RETRY_PAUSE_START = 50;
    private static final int RETRY_PAUSE_MAX = 1000;
    private final Log LOG = LogFactory.getLog(SerialMaster.class);
    protected boolean serialPortOpen;
    protected SerialPortWrapper wrapper;
    protected Transport transport;

    public SerialMaster(SerialPortWrapper wrapper) {
        this(wrapper, true);
    }

    public SerialMaster(SerialPortWrapper wrapper, boolean validateResponse) {
        this.wrapper = wrapper;
        this.validateResponse = validateResponse;
    }

    @Override
    public void init() throws ModbusInitException {
        try {
            this.openConnection(null);
        }
        catch (Exception e) {
            throw new ModbusInitException(e);
        }
    }

    protected void openConnection(MessageControl toClose) throws Exception {
        this.closeConnection(toClose);
        int retries = this.getRetries();
        int retryPause = 50;
        while (true) {
            try {
                this.wrapper.open();
                this.serialPortOpen = true;
                if (this.getePoll() != null) {
                    this.transport = new EpollStreamTransport(this.wrapper.getInputStream(), this.wrapper.getOutputStream(), this.getePoll());
                    break;
                }
                this.transport = new StreamTransport(this.wrapper.getInputStream(), this.wrapper.getOutputStream());
            }
            catch (Exception e) {
                this.close();
                if (retries <= 0) {
                    throw e;
                }
                --retries;
                try {
                    Thread.sleep(retryPause);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((retryPause *= 2) <= 1000) continue;
                retryPause = 1000;
                continue;
            }
            break;
        }
    }

    protected void closeConnection(MessageControl conn) {
        this.closeMessageControl(conn);
        try {
            if (this.serialPortOpen) {
                this.wrapper.close();
                this.serialPortOpen = false;
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().receivedException(e);
        }
        this.transport = null;
    }

    public void close() {
        try {
            this.wrapper.close();
        }
        catch (Exception e) {
            this.LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

