/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.ip.xa;

import com.serotonin.modbus4j.base.ModbusUtils;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.ip.xa.XaMessage;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.sero.messaging.IncomingRequestMessage;
import com.serotonin.modbus4j.sero.messaging.OutgoingRequestMessage;
import com.serotonin.modbus4j.sero.util.queue.ByteQueue;

public class XaMessageRequest
extends XaMessage
implements OutgoingRequestMessage,
IncomingRequestMessage {
    static XaMessageRequest createXaMessageRequest(ByteQueue queue) throws ModbusTransportException {
        int transactionId = ModbusUtils.popShort(queue);
        int protocolId = ModbusUtils.popShort(queue);
        if (protocolId != 0) {
            throw new ModbusTransportException("Unsupported IP protocol id: " + protocolId);
        }
        ModbusUtils.popShort(queue);
        ModbusRequest request = ModbusRequest.createModbusRequest(queue);
        return new XaMessageRequest(request, transactionId);
    }

    public XaMessageRequest(ModbusRequest modbusRequest, int transactionId) {
        super(modbusRequest, transactionId);
    }

    @Override
    public boolean expectsResponse() {
        return this.modbusMessage.getSlaveId() != 0;
    }

    public ModbusRequest getModbusRequest() {
        return (ModbusRequest)this.modbusMessage;
    }
}

