/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.tasks.register;

import com.github.imflog.schema.registry.LocalReference;
import com.github.imflog.schema.registry.LoggingUtils;
import com.github.imflog.schema.registry.SchemaType;
import com.github.imflog.schema.registry.parser.SchemaParser;
import com.github.imflog.schema.registry.tasks.register.RegisterSubject;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ<\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007H\u0002J\u0006\u0010\u001a\u001a\u00020\u0011J\b\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/imflog/schema/registry/tasks/register/RegisterTaskAction;", "", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "rootDir", "Ljava/io/File;", "subjects", "", "Lcom/github/imflog/schema/registry/tasks/register/RegisterSubject;", "outputDir", "", "(Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;Ljava/io/File;Ljava/util/List;Ljava/lang/String;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "outputFile", "registerSchema", "", "subject", "path", "type", "Lcom/github/imflog/schema/registry/SchemaType;", "references", "Lio/confluent/kafka/schemaregistry/client/rest/entities/SchemaReference;", "localReferences", "Lcom/github/imflog/schema/registry/LocalReference;", "run", "writeOutputFileHeader", "", "writeRegisteredSchemaOutput", "schemaId", "kafka-schema-registry-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRegisterTaskAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterTaskAction.kt\ncom/github/imflog/schema/registry/tasks/register/RegisterTaskAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1851#2,2:67\n*S KotlinDebug\n*F\n+ 1 RegisterTaskAction.kt\ncom/github/imflog/schema/registry/tasks/register/RegisterTaskAction\n*L\n28#1:67,2\n*E\n"})
public final class RegisterTaskAction {
    @NotNull
    private final SchemaRegistryClient client;
    @NotNull
    private final File rootDir;
    @NotNull
    private final List<RegisterSubject> subjects;
    private final org.gradle.api.logging.Logger logger;
    @Nullable
    private final File outputFile;

    /*
     * WARNING - void declaration
     */
    public RegisterTaskAction(@NotNull SchemaRegistryClient client, @NotNull File rootDir, @NotNull List<RegisterSubject> subjects, @Nullable String outputDir) {
        File file;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter(subjects, (String)"subjects");
        this.client = client;
        this.rootDir = rootDir;
        this.subjects = subjects;
        this.logger = Logging.getLogger(RegisterTaskAction.class);
        RegisterTaskAction registerTaskAction = this;
        String string = outputDir;
        if (string != null) {
            void it;
            String string2 = string;
            RegisterTaskAction registerTaskAction2 = registerTaskAction;
            boolean bl = false;
            file = FilesKt.resolve((File)FilesKt.resolve((File)this.rootDir, (String)it), (String)"registered.csv");
            registerTaskAction = registerTaskAction2;
        } else {
            file = null;
        }
        registerTaskAction.outputFile = file;
    }

    public final int run() {
        int errorCount = 0;
        this.writeOutputFileHeader();
        Iterable $this$forEach$iv = this.subjects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegisterSubject registerSubject = (RegisterSubject)element$iv;
            boolean bl = false;
            String subject = registerSubject.component1();
            String path = registerSubject.component2();
            SchemaType type = registerSubject.component3();
            List<SchemaReference> references = registerSubject.component4();
            List<LocalReference> localReferences = registerSubject.component5();
            try {
                int schemaId = this.registerSchema(subject, path, type, references, localReferences);
                this.writeRegisteredSchemaOutput(subject, path, schemaId);
            }
            catch (Exception e) {
                this.logger.error("Could not register schema for '" + subject + '\'', (Throwable)e);
                ++errorCount;
            }
        }
        return errorCount;
    }

    private final int registerSchema(String subject, String path, SchemaType type, List<? extends SchemaReference> references, List<LocalReference> localReferences) {
        ParsedSchema parsedSchema = SchemaParser.Companion.provide(type, this.client, this.rootDir).parseSchemaFromFile(subject, path, references, localReferences);
        org.gradle.api.logging.Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        LoggingUtils.INSTANCE.infoIfNotQuiet((Logger)logger, "Registering " + subject + " (from " + path + ')');
        int schemaId = this.client.register(subject, parsedSchema);
        org.gradle.api.logging.Logger logger2 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        LoggingUtils.INSTANCE.infoIfNotQuiet((Logger)logger2, subject + " (from " + path + ") has been registered with id " + schemaId);
        return schemaId;
    }

    private final void writeOutputFileHeader() {
        if (!((Collection)this.subjects).isEmpty() && this.outputFile != null) {
            FilesKt.writeText$default((File)this.outputFile, (String)"subject, path, id\n", null, (int)2, null);
        }
    }

    private final void writeRegisteredSchemaOutput(String subject, String path, int schemaId) {
        block0: {
            File file = this.outputFile;
            if (file == null) break block0;
            FilesKt.appendText$default((File)file, (String)(subject + ", " + path + ", " + schemaId + '\n'), null, (int)2, null);
        }
    }
}

