/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.tasks.download;

import com.github.imflog.schema.registry.LoggingUtils;
import com.github.imflog.schema.registry.SchemaParsingException;
import com.github.imflog.schema.registry.SchemaType;
import com.github.imflog.schema.registry.SchemaTypeKt;
import com.github.imflog.schema.registry.tasks.download.DownloadSubject;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J.\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/imflog/schema/registry/tasks/download/DownloadTaskAction;", "", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "rootDir", "Ljava/io/File;", "subjects", "", "Lcom/github/imflog/schema/registry/tasks/download/DownloadSubject;", "(Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;Ljava/io/File;Ljava/util/List;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "downloadSchema", "Lio/confluent/kafka/schemaregistry/ParsedSchema;", "subject", "expandSubjectPatterns", "parseSchemaWithRemoteReferences", "", "schemaType", "Lcom/github/imflog/schema/registry/SchemaType;", "schemaContent", "references", "Lio/confluent/kafka/schemaregistry/client/rest/entities/SchemaReference;", "parseSubjectRegex", "Lkotlin/text/Regex;", "regex", "run", "", "writeSchemaFiles", "", "downloadSubject", "schema", "kafka-schema-registry-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDownloadTaskAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadTaskAction.kt\ncom/github/imflog/schema/registry/tasks/download/DownloadTaskAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1851#2,2:105\n1360#2:107\n1446#2,2:108\n766#2:110\n857#2,2:111\n1549#2:113\n1620#2,3:114\n1448#2,3:117\n*S KotlinDebug\n*F\n+ 1 DownloadTaskAction.kt\ncom/github/imflog/schema/registry/tasks/download/DownloadTaskAction\n*L\n25#1:105,2\n40#1:107\n40#1:108,2\n44#1:110\n44#1:111,2\n45#1:113\n45#1:114,3\n40#1:117,3\n*E\n"})
public final class DownloadTaskAction {
    @NotNull
    private final SchemaRegistryClient client;
    @NotNull
    private final File rootDir;
    @NotNull
    private final List<DownloadSubject> subjects;
    private final org.gradle.api.logging.Logger logger;

    public DownloadTaskAction(@NotNull SchemaRegistryClient client, @NotNull File rootDir, @NotNull List<DownloadSubject> subjects) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter(subjects, (String)"subjects");
        this.client = client;
        this.rootDir = rootDir;
        this.subjects = subjects;
        this.logger = Logging.getLogger(DownloadTaskAction.class);
    }

    public final int run() {
        int errorCount = 0;
        Iterable $this$forEach$iv = this.expandSubjectPatterns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadSubject downloadSubject = (DownloadSubject)element$iv;
            boolean bl = false;
            org.gradle.api.logging.Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            LoggingUtils.INSTANCE.infoIfNotQuiet((Logger)logger, "Start loading schemas for " + downloadSubject.getSubject());
            try {
                ParsedSchema downloadedSchema = this.downloadSchema(downloadSubject);
                this.writeSchemaFiles(downloadSubject, downloadedSchema);
            }
            catch (Exception e) {
                this.logger.error("Error during schema retrieval for " + downloadSubject.getSubject(), (Throwable)e);
                ++errorCount;
            }
        }
        return errorCount;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DownloadSubject> expandSubjectPatterns() {
        void $this$flatMapTo$iv$iv;
        Supplier subjectsSupplier = Suppliers.memoize(() -> DownloadTaskAction.expandSubjectPatterns$lambda$1(this));
        Iterable $this$flatMap$iv = this.subjects;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            block7: {
                DownloadSubject downloadSubject;
                block5: {
                    block6: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        String subject;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        downloadSubject = (DownloadSubject)element$iv$iv;
                        boolean bl = false;
                        if (!downloadSubject.getRegex()) break block5;
                        list = this.parseSubjectRegex(downloadSubject.getSubject());
                        if (list == null) break block6;
                        List regex = list;
                        boolean bl2 = false;
                        Object object = subjectsSupplier.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"subjectsSupplier.get()");
                        Iterable iterable2 = (Iterable)object;
                        boolean $i$f$filter = false;
                        void var15_15 = $this$filter$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                            subject = (String)element$iv$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)subject, (String)"subject");
                            if (!regex.matches(subject)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        $this$filter$iv = (List)destination$iv$iv2;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            subject = (String)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl4 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)subject, (String)"subject");
                            collection.add(new DownloadSubject(subject, downloadSubject.getOutputPath(), downloadSubject.getVersion(), false, null, 24, null));
                        }
                        List list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
                        list = list2;
                        if (list2 != null) break block7;
                    }
                    list = CollectionsKt.emptyList();
                    break block7;
                }
                list = CollectionsKt.listOf((Object)downloadSubject);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Regex parseSubjectRegex(String regex) {
        Regex regex2;
        try {
            regex2 = new Regex(regex);
        }
        catch (PatternSyntaxException exception) {
            this.logger.error("Unable to compile subject pattern of " + regex + ", skipping", (Throwable)exception);
            regex2 = null;
        }
        return regex2;
    }

    private final ParsedSchema downloadSchema(DownloadSubject subject) {
        SchemaMetadata schemaMetadata = subject.getVersion() == null ? this.client.getLatestSchemaMetadata(subject.getSubject()) : this.client.getSchemaMetadata(subject.getSubject(), subject.getVersion().intValue());
        String string = subject.getSubject();
        String string2 = schemaMetadata.getSchemaType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"schemaMetadata.schemaType");
        SchemaType schemaType = SchemaTypeKt.toSchemaType(string2);
        String string3 = schemaMetadata.getSchema();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"schemaMetadata.schema");
        List list = schemaMetadata.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schemaMetadata.references");
        return this.parseSchemaWithRemoteReferences(string, schemaType, string3, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeSchemaFiles(DownloadSubject downloadSubject, ParsedSchema schema) {
        File outputDir = FilesKt.resolve((File)new File(this.rootDir.toURI()), (String)downloadSubject.getOutputPath());
        outputDir.mkdirs();
        String string = downloadSubject.getOutputFileName();
        if (string == null) {
            string = downloadSubject.getSubject();
        }
        String fileName = string;
        StringBuilder stringBuilder = new StringBuilder().append(fileName).append('.');
        String string2 = schema.schemaType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"schema.schemaType()");
        File outputFile = new File(outputDir, stringBuilder.append(SchemaTypeKt.toSchemaType(string2).getExtension()).toString());
        outputFile.createNewFile();
        org.gradle.api.logging.Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        LoggingUtils.INSTANCE.infoIfNotQuiet((Logger)logger, "Writing file  " + outputFile);
        Object object = outputFile;
        Object object2 = Charsets.UTF_8;
        File file = object;
        int n = 8192;
        Object object3 = file;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = new PrintWriter(object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n));
        object2 = null;
        try {
            PrintWriter out = (PrintWriter)object;
            boolean bl = false;
            out.println(schema.toString());
            file = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private final ParsedSchema parseSchemaWithRemoteReferences(String subject, SchemaType schemaType, String schemaContent, List<? extends SchemaReference> references) {
        Object t = this.client.parseSchema(schemaType.getRegistryType(), schemaContent, references).orElseThrow(() -> DownloadTaskAction.parseSchemaWithRemoteReferences$lambda$7(subject, schemaType));
        Intrinsics.checkNotNullExpressionValue(t, (String)"client\n        .parseSch\u2026on(subject, schemaType) }");
        return (ParsedSchema)t;
    }

    private static final Collection expandSubjectPatterns$lambda$1(DownloadTaskAction this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.client.getAllSubjects();
    }

    private static final SchemaParsingException parseSchemaWithRemoteReferences$lambda$7(String $subject, SchemaType $schemaType) {
        Intrinsics.checkNotNullParameter((Object)$subject, (String)"$subject");
        Intrinsics.checkNotNullParameter((Object)((Object)$schemaType), (String)"$schemaType");
        return new SchemaParsingException($subject, $schemaType);
    }
}

