/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.tasks.config;

import com.github.imflog.schema.registry.RegistryClientWrapper;
import com.github.imflog.schema.registry.tasks.config.ConfigSubject;
import com.github.imflog.schema.registry.tasks.config.ConfigTaskAction;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleScriptException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0007R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/github/imflog/schema/registry/tasks/config/ConfigTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "basicAuth", "Lorg/gradle/api/provider/Property;", "", "getBasicAuth", "()Lorg/gradle/api/provider/Property;", "ssl", "Lorg/gradle/api/provider/MapProperty;", "getSsl", "()Lorg/gradle/api/provider/MapProperty;", "subjects", "Lorg/gradle/api/provider/ListProperty;", "Lcom/github/imflog/schema/registry/tasks/config/ConfigSubject;", "getSubjects", "()Lorg/gradle/api/provider/ListProperty;", "url", "getUrl", "configureSubjects", "", "Companion", "kafka-schema-registry-gradle-plugin"})
public class ConfigTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Input
    @NotNull
    private final Property<String> url;
    @Input
    @NotNull
    private final Property<String> basicAuth;
    @Input
    @NotNull
    private final MapProperty<String, String> ssl;
    @Input
    @NotNull
    private final ListProperty<ConfigSubject> subjects;
    @NotNull
    public static final String TASK_NAME = "configSubjectsTask";

    @Inject
    public ConfigTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.setGroup("registry");
        this.setDescription("Set subject compatibility in registry");
        Property property = objects.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"objects.property(String::class.java)");
        this.url = property;
        Property property2 = objects.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"objects.property(String::class.java)");
        this.basicAuth = property2;
        MapProperty mapProperty = objects.mapProperty(String.class, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty, (String)"objects.mapProperty(Stri\u2026java, String::class.java)");
        this.ssl = mapProperty;
        ListProperty listProperty = objects.listProperty(ConfigSubject.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"objects.listProperty(ConfigSubject::class.java)");
        this.subjects = listProperty;
    }

    @NotNull
    public final Property<String> getUrl() {
        return this.url;
    }

    @NotNull
    public final Property<String> getBasicAuth() {
        return this.basicAuth;
    }

    @NotNull
    public final MapProperty<String, String> getSsl() {
        return this.ssl;
    }

    @NotNull
    public final ListProperty<ConfigSubject> getSubjects() {
        return this.subjects;
    }

    @TaskAction
    public final void configureSubjects() {
        Object object = this.url.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"url.get()");
        String string = (String)object;
        Object object2 = this.basicAuth.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"basicAuth.get()");
        String string2 = (String)object2;
        Object object3 = this.ssl.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"ssl.get()");
        SchemaRegistryClient schemaRegistryClient = RegistryClientWrapper.INSTANCE.client(string, string2, (Map)object3);
        Object object4 = this.subjects.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"subjects.get()");
        int errorCount = new ConfigTaskAction(schemaRegistryClient, (List)object4).run();
        if (errorCount > 0) {
            throw new GradleScriptException(errorCount + " subject configuration not set, see logs for details", new Throwable());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/imflog/schema/registry/tasks/config/ConfigTask$Companion;", "", "()V", "TASK_NAME", "", "kafka-schema-registry-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

