/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.tasks.compatibility;

import com.github.imflog.schema.registry.LocalReference;
import com.github.imflog.schema.registry.LoggingUtils;
import com.github.imflog.schema.registry.SchemaType;
import com.github.imflog.schema.registry.parser.SchemaParser;
import com.github.imflog.schema.registry.tasks.compatibility.CompatibilitySubject;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/imflog/schema/registry/tasks/compatibility/CompatibilityTaskAction;", "", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "rootDir", "Ljava/io/File;", "subjects", "", "Lcom/github/imflog/schema/registry/tasks/compatibility/CompatibilitySubject;", "(Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;Ljava/io/File;Ljava/util/List;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "run", "", "kafka-schema-registry-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCompatibilityTaskAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompatibilityTaskAction.kt\ncom/github/imflog/schema/registry/tasks/compatibility/CompatibilityTaskAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1851#2,2:67\n*S KotlinDebug\n*F\n+ 1 CompatibilityTaskAction.kt\ncom/github/imflog/schema/registry/tasks/compatibility/CompatibilityTaskAction\n*L\n36#1:67,2\n*E\n"})
public final class CompatibilityTaskAction {
    @NotNull
    private final SchemaRegistryClient client;
    @NotNull
    private final File rootDir;
    @NotNull
    private final List<CompatibilitySubject> subjects;
    private final org.gradle.api.logging.Logger logger;

    public CompatibilityTaskAction(@NotNull SchemaRegistryClient client, @NotNull File rootDir, @NotNull List<CompatibilitySubject> subjects) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter(subjects, (String)"subjects");
        this.client = client;
        this.rootDir = rootDir;
        this.subjects = subjects;
        this.logger = Logging.getLogger(CompatibilityTaskAction.class);
    }

    public final int run() {
        int errorCount = 0;
        for (CompatibilitySubject compatibilitySubject : this.subjects) {
            boolean bl;
            String subject = compatibilitySubject.component1();
            String path = compatibilitySubject.component2();
            SchemaType type = compatibilitySubject.component3();
            List<SchemaReference> remoteReferences = compatibilitySubject.component4();
            List<LocalReference> localReferences = compatibilitySubject.component5();
            this.logger.debug("Loading schema for subject(" + subject + ") from " + path + '.');
            try {
                ParsedSchema parsedSchema = SchemaParser.Companion.provide(type, this.client, this.rootDir).parseSchemaFromFile(subject, path, remoteReferences, localReferences);
                boolean isCompatible = this.client.testCompatibility(subject, parsedSchema);
                if (!isCompatible) {
                    try {
                        List list = this.client.testCompatibilityVerbose(subject, parsedSchema);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"client.testCompatibility\u2026se(subject, parsedSchema)");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            this.logger.error("Returned errors : " + it);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bl = isCompatible;
            }
            catch (IOException ioEx) {
                this.logger.error("", (Throwable)ioEx);
                bl = false;
            }
            catch (RestClientException restEx) {
                boolean bl3;
                if (restEx.getErrorCode() == 40401) {
                    bl3 = true;
                } else {
                    this.logger.error("", (Throwable)restEx);
                    bl3 = false;
                }
                bl = bl3;
            }
            boolean isCompatible = bl;
            if (isCompatible) {
                org.gradle.api.logging.Logger logger = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                LoggingUtils.INSTANCE.infoIfNotQuiet((Logger)logger, "Schema " + path + " is compatible with subject: " + subject);
                continue;
            }
            this.logger.error("Schema " + path + " is not compatible with subject: " + subject);
            ++errorCount;
        }
        return errorCount;
    }
}

