/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.parser;

import com.github.imflog.schema.registry.LocalReference;
import com.github.imflog.schema.registry.SchemaParsingException;
import com.github.imflog.schema.registry.SchemaType;
import com.github.imflog.schema.registry.parser.AvroSchemaParser;
import com.github.imflog.schema.registry.parser.JsonSchemaParser;
import com.github.imflog.schema.registry.parser.ProtobufSchemaParser;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015J&\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/github/imflog/schema/registry/parser/SchemaParser;", "", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "rootDir", "Ljava/io/File;", "(Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;Ljava/io/File;)V", "getClient", "()Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "getRootDir", "()Ljava/io/File;", "schemaType", "Lcom/github/imflog/schema/registry/SchemaType;", "getSchemaType", "()Lcom/github/imflog/schema/registry/SchemaType;", "parseSchemaFromFile", "Lio/confluent/kafka/schemaregistry/ParsedSchema;", "subject", "", "schemaPath", "remoteReferences", "", "Lio/confluent/kafka/schemaregistry/client/rest/entities/SchemaReference;", "localReferences", "Lcom/github/imflog/schema/registry/LocalReference;", "resolveLocalReferences", "schemaContent", "Companion", "kafka-schema-registry-gradle-plugin"})
public abstract class SchemaParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaRegistryClient client;
    @NotNull
    private final File rootDir;

    public SchemaParser(@NotNull SchemaRegistryClient client, @NotNull File rootDir) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        this.client = client;
        this.rootDir = rootDir;
    }

    @NotNull
    protected final SchemaRegistryClient getClient() {
        return this.client;
    }

    @NotNull
    protected final File getRootDir() {
        return this.rootDir;
    }

    @NotNull
    public abstract SchemaType getSchemaType();

    @NotNull
    public final ParsedSchema parseSchemaFromFile(@NotNull String subject, @NotNull String schemaPath, @NotNull List<? extends SchemaReference> remoteReferences, @NotNull List<LocalReference> localReferences) throws SchemaParsingException, NotImplementedError {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)schemaPath, (String)"schemaPath");
        Intrinsics.checkNotNullParameter(remoteReferences, (String)"remoteReferences");
        Intrinsics.checkNotNullParameter(localReferences, (String)"localReferences");
        String schemaContent = FilesKt.readText$default((File)FilesKt.resolve((File)this.rootDir, (String)schemaPath), null, (int)1, null);
        String parsedLocalSchemaString = !((Collection)localReferences).isEmpty() ? this.resolveLocalReferences(subject, schemaContent, localReferences) : schemaContent;
        Object t = this.client.parseSchema(this.getSchemaType().getRegistryType(), parsedLocalSchemaString, remoteReferences).orElseThrow(() -> SchemaParser.parseSchemaFromFile$lambda$0(subject, this));
        Intrinsics.checkNotNullExpressionValue(t, (String)"client\n            .pars\u2026on(subject, schemaType) }");
        return (ParsedSchema)t;
    }

    @NotNull
    public abstract String resolveLocalReferences(@NotNull String var1, @NotNull String var2, @NotNull List<LocalReference> var3);

    private static final SchemaParsingException parseSchemaFromFile$lambda$0(String $subject, SchemaParser this$0) {
        Intrinsics.checkNotNullParameter((Object)$subject, (String)"$subject");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new SchemaParsingException($subject, this$0.getSchemaType());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/github/imflog/schema/registry/parser/SchemaParser$Companion;", "", "()V", "provide", "Lcom/github/imflog/schema/registry/parser/SchemaParser;", "schemaType", "Lcom/github/imflog/schema/registry/SchemaType;", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "rootDir", "Ljava/io/File;", "kafka-schema-registry-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SchemaParser provide(@NotNull SchemaType schemaType, @NotNull SchemaRegistryClient client, @NotNull File rootDir) {
            SchemaParser schemaParser;
            Intrinsics.checkNotNullParameter((Object)((Object)schemaType), (String)"schemaType");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            switch (WhenMappings.$EnumSwitchMapping$0[schemaType.ordinal()]) {
                case 1: {
                    schemaParser = new AvroSchemaParser(client, rootDir);
                    break;
                }
                case 2: {
                    schemaParser = new JsonSchemaParser(client, rootDir);
                    break;
                }
                case 3: {
                    schemaParser = new ProtobufSchemaParser(client, rootDir);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return schemaParser;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SchemaType.values().length];
                try {
                    nArray[SchemaType.AVRO.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SchemaType.JSON.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SchemaType.PROTOBUF.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

