/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.parser;

import com.github.imflog.schema.registry.LocalReference;
import com.github.imflog.schema.registry.SchemaType;
import com.github.imflog.schema.registry.parser.SchemaParser;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/github/imflog/schema/registry/parser/JsonSchemaParser;", "Lcom/github/imflog/schema/registry/parser/SchemaParser;", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "rootDir", "Ljava/io/File;", "(Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;Ljava/io/File;)V", "schemaType", "Lcom/github/imflog/schema/registry/SchemaType;", "getSchemaType", "()Lcom/github/imflog/schema/registry/SchemaType;", "resolveLocalReferences", "", "subject", "schemaContent", "localReferences", "", "Lcom/github/imflog/schema/registry/LocalReference;", "Companion", "kafka-schema-registry-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nJsonSchemaParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaParser.kt\ncom/github/imflog/schema/registry/parser/JsonSchemaParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1851#2,2:37\n*S KotlinDebug\n*F\n+ 1 JsonSchemaParser.kt\ncom/github/imflog/schema/registry/parser/JsonSchemaParser\n*L\n27#1:37,2\n*E\n"})
public final class JsonSchemaParser
extends SchemaParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaType schemaType;
    @NotNull
    private static final String DEFS_NODE = "$defs";

    public JsonSchemaParser(@NotNull SchemaRegistryClient client, @NotNull File rootDir) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        super(client, rootDir);
        this.schemaType = SchemaType.JSON;
    }

    @Override
    @NotNull
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    @Override
    @NotNull
    public String resolveLocalReferences(@NotNull String subject, @NotNull String schemaContent, @NotNull List<LocalReference> localReferences) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)schemaContent, (String)"schemaContent");
        Intrinsics.checkNotNullParameter(localReferences, (String)"localReferences");
        JSONObject jsonObj = new JSONObject(schemaContent);
        JSONObject localDefNodes = new JSONObject();
        Iterable $this$forEach$iv = localReferences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalReference reference = (LocalReference)element$iv;
            boolean bl = false;
            localDefNodes.put(reference.getName(), (Object)new JSONObject(reference.content(this.getRootDir())));
        }
        jsonObj.append(DEFS_NODE, (Object)localDefNodes);
        String string = jsonObj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObj.toString()");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/imflog/schema/registry/parser/JsonSchemaParser$Companion;", "", "()V", "DEFS_NODE", "", "kafka-schema-registry-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

