/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.parser;

import com.github.imflog.schema.registry.LocalReference;
import com.github.imflog.schema.registry.SchemaType;
import com.github.imflog.schema.registry.parser.SchemaParser;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/github/imflog/schema/registry/parser/AvroSchemaParser;", "Lcom/github/imflog/schema/registry/parser/SchemaParser;", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "rootDir", "Ljava/io/File;", "(Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;Ljava/io/File;)V", "schemaType", "Lcom/github/imflog/schema/registry/SchemaType;", "getSchemaType", "()Lcom/github/imflog/schema/registry/SchemaType;", "replaceLocalReference", "Lorg/json/JSONObject;", "jsonObject", "localReferences", "", "Lcom/github/imflog/schema/registry/LocalReference;", "replaceType", "", "type", "resolveLocalReferences", "", "subject", "schemaContent", "kafka-schema-registry-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAvroSchemaParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvroSchemaParser.kt\ncom/github/imflog/schema/registry/parser/AvroSchemaParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1549#2:65\n1620#2,3:66\n766#2:69\n857#2,2:70\n1549#2:72\n1620#2,3:73\n1549#2:76\n1620#2,3:77\n1549#2:80\n1620#2,3:81\n*S KotlinDebug\n*F\n+ 1 AvroSchemaParser.kt\ncom/github/imflog/schema/registry/parser/AvroSchemaParser\n*L\n35#1:65\n35#1:66,3\n54#1:69\n54#1:70,2\n55#1:72\n55#1:73,3\n56#1:76\n56#1:77,3\n59#1:80\n59#1:81,3\n*E\n"})
public final class AvroSchemaParser
extends SchemaParser {
    @NotNull
    private final SchemaType schemaType;

    public AvroSchemaParser(@NotNull SchemaRegistryClient client, @NotNull File rootDir) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        super(client, rootDir);
        this.schemaType = SchemaType.AVRO;
    }

    @Override
    @NotNull
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String resolveLocalReferences(@NotNull String subject, @NotNull String schemaContent, @NotNull List<LocalReference> localReferences) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)schemaContent, (String)"schemaContent");
        Intrinsics.checkNotNullParameter(localReferences, (String)"localReferences");
        JSONObject jsonObj = new JSONObject(schemaContent);
        if (jsonObj.has("fields")) {
            Collection<void> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            JSONArray jSONArray = jsonObj.getJSONArray("fields");
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"jsonObj\n                    .getJSONArray(FIELDS)");
            Iterable iterable = (Iterable)jSONArray;
            String string = "fields";
            JSONObject jSONObject = jsonObj;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((void)(it instanceof JSONObject ? this.replaceLocalReference((JSONObject)it, localReferences) : it));
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            jSONObject.put(string, (Object)new JSONArray(collection2));
        }
        String string = jsonObj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObj.toString()");
        return string;
    }

    private final JSONObject replaceLocalReference(JSONObject jsonObject, List<LocalReference> localReferences) {
        if (jsonObject.has("type")) {
            Object object = jsonObject.get("type");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObject.get(TYPE)");
            jsonObject.put("type", this.replaceType(object, localReferences));
        } else if (jsonObject.has("items")) {
            Object object = jsonObject.get("items");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObject.get(ITEMS)");
            jsonObject.put("items", this.replaceType(object, localReferences));
        } else if (jsonObject.has("values")) {
            Object object = jsonObject.get("values");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObject.get(VALUES)");
            jsonObject.put("values", this.replaceType(object, localReferences));
        }
        return jsonObject;
    }

    /*
     * WARNING - void declaration
     */
    private final Object replaceType(Object type, List<LocalReference> localReferences) {
        Object object;
        Object object2 = type;
        if (object2 instanceof String) {
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            LocalReference it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = localReferences;
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LocalReference)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)type)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (LocalReference)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new JSONObject(it.content(this.getRootDir())));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (JSONObject)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.replaceLocalReference((JSONObject)it, localReferences));
            }
            object = (JSONObject)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (object == null) {
                object = type;
            }
        } else if (object2 instanceof JSONArray) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)type;
            boolean $i$f$map = false;
            Iterable $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object item$iv$iv2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(this.replaceType(it, localReferences));
            }
            Collection collection = (List)destination$iv$iv;
            object = new JSONArray(collection);
        } else {
            object = object2 instanceof JSONObject ? this.replaceLocalReference((JSONObject)type, localReferences) : type;
        }
        return object;
    }
}

