/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry;

import io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\rJ\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J(\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\r2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/imflog/schema/registry/RegistryClientWrapper;", "", "()V", "BASIC_AUTH_SOURCE", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "url", "basicAuth", "sslConfigs", "", "getConfig", "getValidatedSslConfig", "kafka-schema-registry-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRegistryClientWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryClientWrapper.kt\ncom/github/imflog/schema/registry/RegistryClientWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,64:1\n819#2:65\n847#2,2:66\n1851#2,2:68\n1238#2,4:72\n453#3:70\n399#3:71\n*S KotlinDebug\n*F\n+ 1 RegistryClientWrapper.kt\ncom/github/imflog/schema/registry/RegistryClientWrapper\n*L\n52#1:65\n52#1:66,2\n55#1:68,2\n61#1:72,4\n61#1:70\n61#1:71\n*E\n"})
public final class RegistryClientWrapper {
    @NotNull
    public static final RegistryClientWrapper INSTANCE = new RegistryClientWrapper();
    private static final Logger logger = LoggerFactory.getLogger(RegistryClientWrapper.class);
    @NotNull
    private static final String BASIC_AUTH_SOURCE = "USER_INFO";

    private RegistryClientWrapper() {
    }

    @NotNull
    public final SchemaRegistryClient client(@NotNull String url, @NotNull String basicAuth2, @NotNull Map<String, String> sslConfigs) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)basicAuth2, (String)"basicAuth");
        Intrinsics.checkNotNullParameter(sslConfigs, (String)"sslConfigs");
        Object[] objectArray = new AbstractSchemaProvider[]{(AbstractSchemaProvider)new AvroSchemaProvider(), (AbstractSchemaProvider)new JsonSchemaProvider(), (AbstractSchemaProvider)new ProtobufSchemaProvider()};
        return (SchemaRegistryClient)new CachedSchemaRegistryClient(CollectionsKt.listOf((Object)url), 100, CollectionsKt.listOf((Object[])objectArray), MapsKt.plus(this.getConfig(basicAuth2), this.getValidatedSslConfig(sslConfigs)));
    }

    private final Map<String, String> getConfig(String basicAuth2) {
        Map map;
        if (Intrinsics.areEqual((Object)basicAuth2, (Object)":")) {
            map = MapsKt.emptyMap();
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"basic.auth.credentials.source", (Object)BASIC_AUTH_SOURCE), TuplesKt.to((Object)"basic.auth.user.info", (Object)basicAuth2)};
            map = MapsKt.mapOf((Pair[])pairArray);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> getValidatedSslConfig(Map<String, ? extends Object> sslConfigs) {
        void $this$mapKeysTo$iv$iv;
        String property;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = sslConfigs.keySet();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            property = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)property, (String)"ssl.", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List wrongProperties = (List)destination$iv$iv;
        boolean $i$a$-let-RegistryClientWrapper$getValidatedSslConfig$32 = false;
        if (CollectionsKt.any((Iterable)wrongProperties)) {
            Iterable $this$forEach$iv = wrongProperties;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                property = (String)element$iv;
                boolean bl = false;
                logger.error(property + " is not a valid sslConfig");
            }
            throw new GradleException("SSL configuration only accept keys from org.apache.kafka.common.config.SslConfigs");
        }
        Map<String, ? extends Object> $this$mapKeys$iv = sslConfigs;
        boolean $i$f$mapKeys = false;
        Map<String, ? extends Object> $i$a$-let-RegistryClientWrapper$getValidatedSslConfig$32 = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string = "schema.registry." + (String)it.getKey();
            Object object2 = object;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            object2.put(string, entry);
        }
        return destination$iv$iv;
    }
}

