/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.download;

import com.github.imflog.schema.registry.download.DownloadSubject;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.avro.Schema;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/imflog/schema/registry/download/DownloadTaskAction;", "", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "subjects", "", "Lcom/github/imflog/schema/registry/download/DownloadSubject;", "rootDir", "Ljava/io/File;", "(Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;Ljava/util/List;Ljava/io/File;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "downloadSchema", "Lorg/apache/avro/Schema;", "subject", "run", "", "writeSchemaFiles", "", "downloadSubject", "schemas", "kafka-schema-registry-gradle-plugin"})
public final class DownloadTaskAction {
    private final Logger logger;
    private final SchemaRegistryClient client;
    private final List<DownloadSubject> subjects;
    private final File rootDir;

    public final int run() {
        int errorCount = 0;
        Iterable $this$forEach$iv = this.subjects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadSubject downloadSubject = (DownloadSubject)element$iv;
            boolean bl = false;
            this.logger.info("Start loading schemas for " + downloadSubject.getSubject());
            try {
                Schema downloadedSchema = this.downloadSchema(downloadSubject);
                this.writeSchemaFiles(downloadSubject, downloadedSchema);
            }
            catch (Exception e) {
                this.logger.error("Error during schema retrieval for " + downloadSubject.getSubject(), (Throwable)e);
                int n = errorCount;
                errorCount = n + 1;
            }
        }
        return errorCount;
    }

    private final Schema downloadSchema(DownloadSubject subject) {
        SchemaMetadata schemaMetadata = subject.getVersion() == null ? this.client.getLatestSchemaMetadata(subject.getSubject()) : this.client.getSchemaMetadata(subject.getSubject(), subject.getVersion().intValue());
        Schema.Parser parser = new Schema.Parser();
        SchemaMetadata schemaMetadata2 = schemaMetadata;
        Intrinsics.checkExpressionValueIsNotNull((Object)schemaMetadata2, (String)"schemaMetadata");
        Schema schema = parser.parse(schemaMetadata2.getSchema());
        Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"Schema.Parser().parse(schemaMetadata.schema)");
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeSchemaFiles(DownloadSubject downloadSubject, Schema schemas) {
        File outputDir = new File(this.rootDir, downloadSubject.getFile());
        outputDir.mkdirs();
        File outputFile = new File(outputDir, downloadSubject.getSubject() + ".avsc");
        outputFile.createNewFile();
        this.logger.info("Writing file  " + outputFile);
        Object object = outputFile;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        File file = object;
        int n = 8192;
        boolean bl2 = false;
        Object object2 = file;
        boolean bl3 = false;
        Object object3 = object2;
        boolean bl4 = false;
        object3 = new FileOutputStream((File)object3);
        bl4 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl3 = false;
        BufferedWriter bufferedWriter = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        Writer writer = bufferedWriter;
        object = new PrintWriter(writer);
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            PrintWriter out = (PrintWriter)object;
            boolean bl6 = false;
            out.println(schemas.toString(true));
            file = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public DownloadTaskAction(@NotNull SchemaRegistryClient client, @NotNull List<DownloadSubject> subjects, @NotNull File rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull(subjects, (String)"subjects");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        this.client = client;
        this.subjects = subjects;
        this.rootDir = rootDir;
        this.logger = Logging.getLogger(DownloadTaskAction.class);
    }
}

