/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.config;

import com.github.imflog.schema.registry.config.ConfigSubject;
import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/imflog/schema/registry/config/ConfigTaskAction;", "", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "subjects", "", "Lcom/github/imflog/schema/registry/config/ConfigSubject;", "(Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;Ljava/util/List;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "run", "", "kafka-schema-registry-gradle-plugin"})
public final class ConfigTaskAction {
    private final Logger logger;
    private final SchemaRegistryClient client;
    private final List<ConfigSubject> subjects;

    /*
     * WARNING - void declaration
     */
    public final int run() {
        int errorCount = 0;
        for (ConfigSubject configSubject : this.subjects) {
            void subject;
            String string = configSubject.component1();
            String config = configSubject.component2();
            this.logger.debug((String)subject + ": setting config " + config);
            try {
                AvroCompatibilityLevel.valueOf((String)config);
                this.client.updateCompatibility((String)subject, config);
            }
            catch (IllegalArgumentException ex) {
                this.logger.error('\'' + config + "' is not a valid schema registry compatibility", (Throwable)ex);
                ++errorCount;
            }
            catch (RestClientException ex) {
                this.logger.error("Error during compatibility update for " + (String)subject, (Throwable)ex);
                ++errorCount;
            }
        }
        return errorCount;
    }

    public ConfigTaskAction(@NotNull SchemaRegistryClient client, @NotNull List<ConfigSubject> subjects) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull(subjects, (String)"subjects");
        this.client = client;
        this.subjects = subjects;
        this.logger = Logging.getLogger(ConfigTaskAction.class);
    }
}

