/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.compatibility;

import com.github.imflog.schema.registry.compatibility.CompatibilitySubject;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u001e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/imflog/schema/registry/compatibility/CompatibilityTaskAction;", "", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "subjects", "", "Lcom/github/imflog/schema/registry/compatibility/CompatibilitySubject;", "rootDir", "Ljava/io/File;", "(Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;Ljava/util/List;Ljava/io/File;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "loadDependencies", "", "dependencies", "", "parser", "Lorg/apache/avro/Schema$Parser;", "parseSchema", "Lorg/apache/avro/Schema;", "path", "parseSchemas", "run", "", "kafka-schema-registry-gradle-plugin"})
public final class CompatibilityTaskAction {
    private final Logger logger;
    private final SchemaRegistryClient client;
    private final List<CompatibilitySubject> subjects;
    private final File rootDir;

    /*
     * WARNING - void declaration
     */
    public final int run() {
        int errorCount = 0;
        for (CompatibilitySubject compatibilitySubject : this.subjects) {
            boolean bl;
            void path;
            void subject;
            String string = compatibilitySubject.component1();
            String string2 = compatibilitySubject.component2();
            List<String> dependencies = compatibilitySubject.component3();
            this.logger.debug("Loading schema for subject(" + (String)subject + ") from " + (String)path + '.');
            Schema parsedSchema = this.parseSchemas((String)path, dependencies);
            try {
                bl = this.client.testCompatibility((String)subject, parsedSchema);
            }
            catch (RestClientException ex) {
                bl = ex.getErrorCode() == 40401;
            }
            boolean compatible = bl;
            if (compatible) {
                this.logger.info("Schema " + (String)path + " is compatible with subject(" + (String)subject + ')');
                continue;
            }
            this.logger.error("Schema " + (String)path + " is not compatible with subject(" + (String)subject + ')');
            ++errorCount;
        }
        return errorCount;
    }

    private final Schema parseSchemas(String path, List<String> dependencies) {
        Schema.Parser parser = new Schema.Parser();
        this.loadDependencies(dependencies, parser);
        return this.parseSchema(parser, path);
    }

    private final void loadDependencies(List<String> dependencies, Schema.Parser parser) {
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)dependencies);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.parseSchema(parser, it);
        }
    }

    private final Schema parseSchema(Schema.Parser parser, String path) {
        String schemaContent = FilesKt.readText$default((File)new File(this.rootDir, path), null, (int)1, null);
        Schema schema = parser.parse(schemaContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"parser.parse(schemaContent)");
        return schema;
    }

    public CompatibilityTaskAction(@NotNull SchemaRegistryClient client, @NotNull List<CompatibilitySubject> subjects, @NotNull File rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull(subjects, (String)"subjects");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        this.client = client;
        this.subjects = subjects;
        this.rootDir = rootDir;
        this.logger = Logging.getLogger(CompatibilityTaskAction.class);
    }
}

