/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry.compatibility;

import com.github.imflog.schema.registry.RegistryClientWrapper;
import com.github.imflog.schema.registry.compatibility.CompatibilitySubject;
import com.github.imflog.schema.registry.compatibility.CompatibilityTaskAction;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleScriptException;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/github/imflog/schema/registry/compatibility/CompatibilityTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "basicAuth", "Lorg/gradle/api/provider/Property;", "", "getBasicAuth", "()Lorg/gradle/api/provider/Property;", "subjects", "Lorg/gradle/api/provider/ListProperty;", "Lcom/github/imflog/schema/registry/compatibility/CompatibilitySubject;", "getSubjects", "()Lorg/gradle/api/provider/ListProperty;", "url", "getUrl", "testCompatibility", "", "Companion", "kafka-schema-registry-gradle-plugin"})
public class CompatibilityTask
extends DefaultTask {
    @Input
    @NotNull
    private final Property<String> url;
    @Input
    @NotNull
    private final Property<String> basicAuth;
    @Input
    @NotNull
    private final ListProperty<CompatibilitySubject> subjects;
    @NotNull
    public static final String TASK_NAME = "testSchemasTask";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Property<String> getUrl() {
        return this.url;
    }

    @NotNull
    public final Property<String> getBasicAuth() {
        return this.basicAuth;
    }

    @NotNull
    public final ListProperty<CompatibilitySubject> getSubjects() {
        return this.subjects;
    }

    @TaskAction
    public final void testCompatibility() {
        Object object = this.url.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"url.get()");
        String string = (String)object;
        Object object2 = this.basicAuth.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"basicAuth.get()");
        SchemaRegistryClient schemaRegistryClient = RegistryClientWrapper.INSTANCE.client(string, (String)object2);
        Object object3 = this.subjects.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"subjects.get()");
        List list = (List)object3;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootDir");
        int errorCount = new CompatibilityTaskAction(schemaRegistryClient, list, file).run();
        if (errorCount > 0) {
            throw (Throwable)new GradleScriptException(errorCount + " schemas not compatible, see logs for details.", new Throwable());
        }
    }

    @Inject
    public CompatibilityTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        this.setGroup("registry");
        this.setDescription("Test compatibility against registry");
        Property property = objects.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objects.property(String::class.java)");
        this.url = property;
        Property property2 = objects.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"objects.property(String::class.java)");
        this.basicAuth = property2;
        ListProperty listProperty = objects.listProperty(CompatibilitySubject.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objects.listProperty(Com\u2026ilitySubject::class.java)");
        this.subjects = listProperty;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/imflog/schema/registry/compatibility/CompatibilityTask$Companion;", "", "()V", "TASK_NAME", "", "kafka-schema-registry-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

