/*
 * Decompiled with CFR 0.152.
 */
package com.github.imflog.schema.registry;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/github/imflog/schema/registry/RegistryClientWrapper;", "", "()V", "BASIC_AUTH_SOURCE", "", "client", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "url", "basicAuth", "getConfig", "", "kafka-schema-registry-gradle-plugin"})
public final class RegistryClientWrapper {
    private static final String BASIC_AUTH_SOURCE = "USER_INFO";
    public static final RegistryClientWrapper INSTANCE;

    @NotNull
    public final SchemaRegistryClient client(@NotNull String url, @NotNull String basicAuth2) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)basicAuth2, (String)"basicAuth");
        return (SchemaRegistryClient)new CachedSchemaRegistryClient(url, 100, this.getConfig(basicAuth2));
    }

    private final Map<String, String> getConfig(String basicAuth2) {
        Map map;
        if (Intrinsics.areEqual((Object)basicAuth2, (Object)":")) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        } else {
            map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"basic.auth.credentials.source", (Object)BASIC_AUTH_SOURCE), TuplesKt.to((Object)"basic.auth.user.info", (Object)basicAuth2)});
        }
        return map;
    }

    private RegistryClientWrapper() {
    }

    static {
        RegistryClientWrapper registryClientWrapper;
        INSTANCE = registryClientWrapper = new RegistryClientWrapper();
    }
}

