/*
 * Decompiled with CFR 0.152.
 */
package com.github.iielse.imageviewer.widgets;

import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.github.iielse.imageviewer.ImageViewerViewModel;
import com.github.iielse.imageviewer.utils.Config;
import com.github.iielse.imageviewer.utils.ViewModelUtils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001/B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0002J\u0012\u0010)\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\b\u0010*\u001a\u00020&H\u0014J\u0010\u0010+\u001a\u00020&2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\u0011H\u0002J\b\u0010.\u001a\u00020&H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000e\u001a\u0004\b\u001a\u0010\fR\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000e\u001a\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lcom/github/iielse/imageviewer/widgets/SubsamplingScaleImageView2;", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "changedCenter", "Landroid/graphics/PointF;", "dismissEdge", "", "getDismissEdge", "()F", "dismissEdge$delegate", "Lkotlin/Lazy;", "fakeDragOffset", "imageLoaded", "", "initCenter", "initScale", "Ljava/lang/Float;", "lastX", "lastY", "listener", "Lcom/github/iielse/imageviewer/widgets/SubsamplingScaleImageView2$Listener;", "scaledTouchSlop", "getScaledTouchSlop", "scaledTouchSlop$delegate", "singleTouch", "viewModel", "Lcom/github/iielse/imageviewer/ImageViewerViewModel;", "getViewModel", "()Lcom/github/iielse/imageviewer/ImageViewerViewModel;", "viewModel$delegate", "dispatchTouchEvent", "event", "Landroid/view/MotionEvent;", "fakeDrag", "", "offsetX", "offsetY", "handleDispatchTouchEvent", "onDetachedFromWindow", "setListener", "setSingleTouch", "value", "up", "Listener", "imageviewer_release"})
public final class SubsamplingScaleImageView2
extends SubsamplingScaleImageView {
    @NotNull
    private final Lazy viewModel$delegate;
    @Nullable
    private PointF initCenter;
    @Nullable
    private PointF changedCenter;
    @Nullable
    private Float initScale;
    @NotNull
    private final Lazy scaledTouchSlop$delegate;
    @NotNull
    private final Lazy dismissEdge$delegate;
    private boolean imageLoaded;
    private boolean singleTouch;
    private float fakeDragOffset;
    private float lastX;
    private float lastY;
    @Nullable
    private Listener listener;

    @JvmOverloads
    public SubsamplingScaleImageView2(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.viewModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImageViewerViewModel>(this){
            final /* synthetic */ SubsamplingScaleImageView2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ImageViewerViewModel invoke() {
                return ViewModelUtils.INSTANCE.provideViewModel((View)this.this$0, ImageViewerViewModel.class);
            }
        }));
        this.scaledTouchSlop$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Float>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            public final float invoke() {
                return (float)ViewConfiguration.get((Context)this.$context).getScaledTouchSlop() * Config.INSTANCE.getSWIPE_TOUCH_SLOP();
            }
        }));
        this.dismissEdge$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Float>(this){
            final /* synthetic */ SubsamplingScaleImageView2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final float invoke() {
                return (float)this.this$0.getHeight() * Config.INSTANCE.getDISMISS_FRACTION();
            }
        }));
        this.singleTouch = true;
        this.setOnStateChangedListener(new SubsamplingScaleImageView.OnStateChangedListener(){

            public void onScaleChanged(float newScale, int origin) {
            }

            public void onCenterChanged(@Nullable PointF newCenter, int origin) {
                changedCenter = newCenter;
            }
        });
        this.setOnImageEventListener((SubsamplingScaleImageView.OnImageEventListener)new SubsamplingScaleImageView.DefaultOnImageEventListener(){

            public void onImageLoaded() {
                imageLoaded = true;
            }
        });
    }

    public /* synthetic */ SubsamplingScaleImageView2(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final ImageViewerViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        boolean bl = false;
        return (ImageViewerViewModel)((Object)lazy.getValue());
    }

    private final float getScaledTouchSlop() {
        Lazy lazy = this.scaledTouchSlop$delegate;
        boolean bl = false;
        return ((Number)lazy.getValue()).floatValue();
    }

    private final float getDismissEdge() {
        Lazy lazy = this.dismissEdge$delegate;
        boolean bl = false;
        return ((Number)lazy.getValue()).floatValue();
    }

    public final void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public boolean dispatchTouchEvent(@Nullable MotionEvent event) {
        if (Config.INSTANCE.getSWIPE_DISMISS() && Config.INSTANCE.getVIEWER_ORIENTATION() == 0) {
            this.handleDispatchTouchEvent(event);
        }
        return super.dispatchTouchEvent(event);
    }

    private final void handleDispatchTouchEvent(MotionEvent event) {
        MotionEvent motionEvent;
        Integer n;
        if (!this.imageLoaded) {
            return;
        }
        if (this.initScale == null) {
            this.initScale = Float.valueOf(this.getScale());
            this.initCenter = this.getCenter();
            this.changedCenter = this.getCenter();
        }
        Integer n2 = n = (motionEvent = event) == null ? null : Integer.valueOf(motionEvent.getActionMasked());
        int n3 = 5;
        if (n2 != null && n2 == n3) {
            this.setSingleTouch(false);
            this.animate().translationX(0.0f).translationY(0.0f).scaleX(1.0f).scaleY(1.0f).setDuration(200L).start();
        } else {
            boolean bl;
            Integer n4 = n;
            n3 = 1;
            if (n4 != null && n4 == n3) {
                bl = true;
            } else {
                Integer n5 = n;
                n3 = 3;
                bl = n5 != null && n5 == n3;
            }
            if (bl) {
                this.up();
            } else {
                Integer n6 = n;
                n3 = 2;
                if (n6 != null && n6 == n3 && this.singleTouch && Intrinsics.areEqual((float)this.getScale(), (Float)this.initScale)) {
                    float f;
                    Float f2;
                    PointF pointF = this.changedCenter;
                    Float f3 = f2 = pointF == null ? null : Float.valueOf(pointF.y);
                    Object object = f2 == null ? ((pointF = this.initCenter) == null ? null : Float.valueOf(pointF.y)) : f2;
                    f2 = this.initCenter;
                    if (Intrinsics.areEqual((Float)object, (float)(f2 == null ? 0.0f : (f = ((PointF)f2).y)))) {
                        if (this.lastX == 0.0f) {
                            this.lastX = event.getRawX();
                        }
                        if (this.lastY == 0.0f) {
                            this.lastY = event.getRawY();
                        }
                        float offsetX = event.getRawX() - this.lastX;
                        float offsetY = event.getRawY() - this.lastY;
                        this.fakeDrag(offsetX, offsetY);
                    }
                }
            }
        }
    }

    private final void fakeDrag(float offsetX, float offsetY) {
        if (this.fakeDragOffset == 0.0f) {
            if (offsetY > this.getScaledTouchSlop()) {
                this.fakeDragOffset = this.getScaledTouchSlop();
            } else if (offsetY < -this.getScaledTouchSlop()) {
                this.fakeDragOffset = -this.getScaledTouchSlop();
            }
        }
        if (!(this.fakeDragOffset == 0.0f)) {
            float fixedOffsetY = offsetY - this.fakeDragOffset;
            ViewParent viewParent = this.getParent();
            if (viewParent != null) {
                viewParent.requestDisallowInterceptTouchEvent(true);
            }
            float f = -1.0f;
            float f2 = 1.0f;
            float f3 = fixedOffsetY / (float)this.getHeight();
            boolean bl = false;
            f2 = Math.min(f2, f3);
            boolean bl2 = false;
            f = Math.max(f, f2);
            boolean bl3 = false;
            float fraction = Math.abs(f);
            float f4 = 0.4f;
            bl2 = false;
            float fakeScale = 1.0f - Math.min(f4, fraction);
            this.setScaleX(fakeScale);
            this.setScaleY(fakeScale);
            this.setTranslationY(fixedOffsetY);
            this.setTranslationX(offsetX / (float)2);
            Listener listener = this.listener;
            if (listener != null) {
                listener.onDrag(this, fraction);
            }
        }
    }

    private final void up() {
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(false);
        }
        this.setSingleTouch(true);
        this.fakeDragOffset = 0.0f;
        this.lastX = 0.0f;
        this.lastY = 0.0f;
        float f = this.getTranslationY();
        boolean bl = false;
        if (Math.abs(f) > this.getDismissEdge()) {
            Listener listener = this.listener;
            if (listener != null) {
                listener.onRelease(this);
            }
        } else {
            float offsetY = this.getTranslationY();
            float f2 = 1.0f;
            float f3 = offsetY / (float)this.getHeight();
            boolean bl2 = false;
            float fraction = Math.min(f2, f3);
            Listener listener = this.listener;
            if (listener != null) {
                listener.onRestore(this, fraction);
            }
            this.animate().translationX(0.0f).translationY(0.0f).scaleX(1.0f).scaleY(1.0f).setDuration(200L).start();
        }
    }

    private final void setSingleTouch(boolean value) {
        this.singleTouch = value;
        ImageViewerViewModel imageViewerViewModel = this.getViewModel();
        if (imageViewerViewModel != null) {
            imageViewerViewModel.setViewerUserInputEnabled(value);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.animate().cancel();
    }

    @JvmOverloads
    public SubsamplingScaleImageView2(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\n"}, d2={"Lcom/github/iielse/imageviewer/widgets/SubsamplingScaleImageView2$Listener;", "", "onDrag", "", "view", "Lcom/github/iielse/imageviewer/widgets/SubsamplingScaleImageView2;", "fraction", "", "onRelease", "onRestore", "imageviewer_release"})
    public static interface Listener {
        public void onDrag(@NotNull SubsamplingScaleImageView2 var1, float var2);

        public void onRestore(@NotNull SubsamplingScaleImageView2 var1, float var2);

        public void onRelease(@NotNull SubsamplingScaleImageView2 var1);
    }
}

