/*
 * Decompiled with CFR 0.152.
 */
package com.github.iielse.imageviewer.widgets.video;

import android.content.Context;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import android.view.View;
import com.github.iielse.imageviewer.utils.Config;
import com.github.iielse.imageviewer.widgets.video.ExoSourceManager;
import com.github.iielse.imageviewer.widgets.video.ExoVideoView;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.source.LoopingMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.util.EventLogger;
import com.google.android.exoplayer2.video.VideoListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012*\u0001#\b\u0016\u0018\u00002\u00020\u0001:\u00019B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012J\b\u0010*\u001a\u00020!H\u0002J\b\u0010+\u001a\u00020(H\u0014J\b\u0010,\u001a\u00020(H\u0014J\u0006\u0010-\u001a\u00020(J\b\u0010.\u001a\u0004\u0018\u00010!J\u000e\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u0019J\u0006\u00101\u001a\u00020(J\u0006\u00102\u001a\u00020(J\u0006\u00103\u001a\u00020(J\u0010\u00104\u001a\u00020(2\b\u00105\u001a\u0004\u0018\u00010&J\u0018\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0002R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView;", "Landroid/view/TextureView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "exoSourceManager", "Lcom/github/iielse/imageviewer/widgets/video/ExoSourceManager;", "kotlin.jvm.PlatformType", "getExoSourceManager", "()Lcom/github/iielse/imageviewer/widgets/video/ExoSourceManager;", "exoSourceManager$delegate", "Lkotlin/Lazy;", "listeners", "", "Lcom/google/android/exoplayer2/analytics/AnalyticsListener;", "logger", "Lcom/google/android/exoplayer2/util/EventLogger;", "getLogger", "()Lcom/google/android/exoplayer2/util/EventLogger;", "logger$delegate", "playUrl", "", "prepared", "", "getPrepared", "()Z", "setPrepared", "(Z)V", "simpleExoPlayer", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "videoListener", "com/github/iielse/imageviewer/widgets/video/ExoVideoView$videoListener$1", "Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView$videoListener$1;", "videoRenderedCallback", "Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView$VideoRenderedListener;", "addAnalyticsListener", "", "analyticsListener", "newSimpleExoPlayer", "onAttachedToWindow", "onDetachedFromWindow", "pause", "player", "prepare", "url", "release", "reset", "resume", "setVideoRenderedCallback", "listener", "updateTextureViewSize", "videoWidth", "videoHeight", "VideoRenderedListener", "imageviewer_release"})
public class ExoVideoView
extends TextureView {
    private final Lazy exoSourceManager$delegate;
    private final Lazy logger$delegate;
    private SimpleExoPlayer simpleExoPlayer;
    private VideoRenderedListener videoRenderedCallback;
    private final List<AnalyticsListener> listeners;
    private String playUrl;
    private boolean prepared;
    private final videoListener.1 videoListener;
    private HashMap _$_findViewCache;

    private final ExoSourceManager getExoSourceManager() {
        Lazy lazy = this.exoSourceManager$delegate;
        ExoVideoView exoVideoView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ExoSourceManager)lazy.getValue();
    }

    private final EventLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        ExoVideoView exoVideoView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (EventLogger)lazy.getValue();
    }

    protected final boolean getPrepared() {
        return this.prepared;
    }

    protected final void setPrepared(boolean bl) {
        this.prepared = bl;
    }

    public final void prepare(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (Config.INSTANCE.getDEBUG()) {
            Log.i((String)"viewer", (String)("video prepare " + url + ' ' + this.simpleExoPlayer));
        }
        this.playUrl = url;
    }

    public final void resume() {
        block4: {
            String string = this.playUrl;
            if (string == null) {
                return;
            }
            String url = string;
            if (Config.INSTANCE.getDEBUG()) {
                Log.i((String)"viewer", (String)("video resume " + url + ' ' + this.simpleExoPlayer));
            }
            if (this.simpleExoPlayer == null) {
                this.prepared = false;
                this.setAlpha(0.0f);
                this.newSimpleExoPlayer();
                ExoSourceManager exoSourceManager2 = this.getExoSourceManager();
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                MediaSource mediaSource = exoSourceManager2.getMediaSource(url, true, true, true, context.getCacheDir(), null);
                Intrinsics.checkExpressionValueIsNotNull((Object)mediaSource, (String)"exoSourceManager.getMedi\u2026, context.cacheDir, null)");
                MediaSource videoSource = mediaSource;
                SimpleExoPlayer simpleExoPlayer = this.simpleExoPlayer;
                if (simpleExoPlayer != null) {
                    simpleExoPlayer.prepare((MediaSource)new LoopingMediaSource(videoSource));
                }
            }
            SimpleExoPlayer simpleExoPlayer = this.simpleExoPlayer;
            if (simpleExoPlayer == null) break block4;
            simpleExoPlayer.setPlayWhenReady(true);
        }
    }

    public final void pause() {
        block1: {
            if (Config.INSTANCE.getDEBUG()) {
                Log.i((String)"viewer", (String)("video pause " + this.playUrl + ' ' + this.simpleExoPlayer));
            }
            SimpleExoPlayer simpleExoPlayer = this.simpleExoPlayer;
            if (simpleExoPlayer == null) break block1;
            simpleExoPlayer.setPlayWhenReady(false);
        }
    }

    public final void reset() {
        block2: {
            if (Config.INSTANCE.getDEBUG()) {
                Log.i((String)"viewer", (String)("video reset " + this.playUrl + ' ' + this.simpleExoPlayer));
            }
            SimpleExoPlayer simpleExoPlayer = this.simpleExoPlayer;
            if (simpleExoPlayer != null) {
                simpleExoPlayer.seekTo(0L);
            }
            SimpleExoPlayer simpleExoPlayer2 = this.simpleExoPlayer;
            if (simpleExoPlayer2 == null) break block2;
            simpleExoPlayer2.setPlayWhenReady(false);
        }
    }

    public final void release() {
        SimpleExoPlayer simpleExoPlayer = this.simpleExoPlayer;
        if (simpleExoPlayer == null) {
            return;
        }
        SimpleExoPlayer player = simpleExoPlayer;
        if (Config.INSTANCE.getDEBUG()) {
            Log.i((String)"viewer", (String)("video release " + this.playUrl + ' ' + player));
        }
        player.setPlayWhenReady(false);
        player.setVideoTextureView(null);
        player.removeVideoListener((VideoListener)this.videoListener);
        player.removeAnalyticsListener((AnalyticsListener)this.getLogger());
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnalyticsListener it = (AnalyticsListener)element$iv;
            boolean bl = false;
            player.removeAnalyticsListener(it);
        }
        player.release();
        this.simpleExoPlayer = null;
    }

    public final void setVideoRenderedCallback(@Nullable VideoRenderedListener listener) {
        this.videoRenderedCallback = listener;
    }

    public final void addAnalyticsListener(@NotNull AnalyticsListener analyticsListener) {
        Intrinsics.checkParameterIsNotNull((Object)analyticsListener, (String)"analyticsListener");
        if (!this.listeners.contains(analyticsListener)) {
            this.listeners.add(analyticsListener);
        }
    }

    @Nullable
    public final SimpleExoPlayer player() {
        block2: {
            String string = this.playUrl;
            if (string == null) {
                return null;
            }
            String url = string;
            if (this.simpleExoPlayer != null) break block2;
            this.prepared = false;
            this.setAlpha(0.0f);
            this.newSimpleExoPlayer();
            ExoSourceManager exoSourceManager2 = this.getExoSourceManager();
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            MediaSource mediaSource = exoSourceManager2.getMediaSource(url, true, true, true, context.getCacheDir(), null);
            Intrinsics.checkExpressionValueIsNotNull((Object)mediaSource, (String)"exoSourceManager.getMedi\u2026, context.cacheDir, null)");
            MediaSource videoSource = mediaSource;
            SimpleExoPlayer simpleExoPlayer = this.simpleExoPlayer;
            if (simpleExoPlayer != null) {
                simpleExoPlayer.prepare((MediaSource)new LoopingMediaSource(videoSource));
            }
        }
        return this.simpleExoPlayer;
    }

    private final SimpleExoPlayer newSimpleExoPlayer() {
        this.release();
        if (Config.INSTANCE.getDEBUG()) {
            Log.i((String)"viewer", (String)("video newSimpleExoPlayer " + this.playUrl));
        }
        SimpleExoPlayer simpleExoPlayer = new SimpleExoPlayer.Builder(this.getContext()).build();
        boolean bl = false;
        boolean bl2 = false;
        SimpleExoPlayer it = simpleExoPlayer;
        boolean bl3 = false;
        it.setVideoTextureView((TextureView)this);
        it.addVideoListener((VideoListener)this.videoListener);
        if (Config.INSTANCE.getDEBUG()) {
            it.addAnalyticsListener((AnalyticsListener)this.getLogger());
        }
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnalyticsListener userListener = (AnalyticsListener)element$iv;
            boolean bl4 = false;
            it.addAnalyticsListener(userListener);
        }
        this.simpleExoPlayer = it;
        SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleExoPlayer2, (String)"SimpleExoPlayer.Builder(\u2026eExoPlayer = it\n        }");
        return simpleExoPlayer2;
    }

    private final void updateTextureViewSize(int videoWidth, int videoHeight) {
        float sx = (float)this.getWidth() * 1.0f / (float)videoWidth;
        float sy = (float)this.getHeight() * 1.0f / (float)videoHeight;
        Matrix matrix = new Matrix();
        matrix.postScale((float)videoWidth * 1.0f / (float)this.getWidth(), (float)videoHeight * 1.0f / (float)this.getHeight());
        Matrix matrix2 = matrix;
        boolean bl = false;
        float f = Math.min(sx, sy);
        bl = false;
        float f2 = Math.min(sx, sy);
        matrix2.postScale(f, f2);
        matrix.postTranslate(sx > sy ? ((float)this.getWidth() - (float)videoWidth * sy) / (float)2 : 0.0f, sx > sy ? 0.0f : ((float)this.getHeight() - (float)videoHeight * sx) / (float)2);
        this.setTransform(matrix);
        this.invalidate();
        this.setAlpha(1.0f);
        VideoRenderedListener videoRenderedListener = this.videoRenderedCallback;
        if (videoRenderedListener != null) {
            videoRenderedListener.onRendered(this);
        }
        this.prepared = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (Config.INSTANCE.getDEBUG()) {
            Log.i((String)"viewer", (String)("video onDetachedFromWindow " + this.playUrl + ' ' + this.simpleExoPlayer));
        }
        this.release();
    }

    protected void onAttachedToWindow() {
        block2: {
            super.onAttachedToWindow();
            if (this.simpleExoPlayer != null) break block2;
            if (Config.INSTANCE.getDEBUG()) {
                Log.i((String)"viewer", (String)("video onAttachedToWindow " + this.playUrl));
            }
            String string = this.playUrl;
            if (string != null) {
                String string2 = string;
                ExoVideoView exoVideoView = this;
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string2;
                boolean bl3 = false;
                exoVideoView.prepare(p1);
            }
        }
    }

    @JvmOverloads
    public ExoVideoView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.exoSourceManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ExoSourceManager>(context){
            final /* synthetic */ Context $context;

            public final ExoSourceManager invoke() {
                return ExoSourceManager.newInstance(this.$context, null);
            }
            {
                this.$context = context;
                super(0);
            }
        }));
        this.logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
        ExoVideoView exoVideoView = this;
        boolean bl = false;
        exoVideoView.listeners = list = (List)new ArrayList();
        this.videoListener = new VideoListener(this){
            final /* synthetic */ ExoVideoView this$0;

            public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
                ExoVideoView.access$updateTextureViewSize(this.this$0, width, height);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public /* synthetic */ ExoVideoView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ExoVideoView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ExoVideoView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$updateTextureViewSize(ExoVideoView $this, int videoWidth, int videoHeight) {
        $this.updateTextureViewSize(videoWidth, videoHeight);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView$VideoRenderedListener;", "", "onRendered", "", "view", "Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView;", "imageviewer_release"})
    public static interface VideoRenderedListener {
        public void onRendered(@NotNull ExoVideoView var1);
    }
}

