/*
 * Decompiled with CFR 0.152.
 */
package com.github.iielse.imageviewer.core;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.github.iielse.imageviewer.core.DataProvider;
import com.github.iielse.imageviewer.core.ImageLoader;
import com.github.iielse.imageviewer.core.OverlayCustomizer;
import com.github.iielse.imageviewer.core.Photo;
import com.github.iielse.imageviewer.core.Transformer;
import com.github.iielse.imageviewer.core.VHCustomizer;
import com.github.iielse.imageviewer.core.ViewerCallback;
import com.github.iielse.imageviewer.utils.Config;
import com.github.iielse.imageviewer.widgets.video.ExoVideoView2;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\n\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\u0006J\u0006\u0010\u001b\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\rJ\u0006\u0010\u001d\u001a\u00020\u000fJ\u0006\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u001f\u001a\u00020\u0013J\u0010\u0010 \u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010!\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\"\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/github/iielse/imageviewer/core/Components;", "", "()V", "dataProvider", "Lcom/github/iielse/imageviewer/core/DataProvider;", "imageLoader", "Lcom/github/iielse/imageviewer/core/ImageLoader;", "initKey", "", "Ljava/lang/Long;", "initialize", "", "overlayCustomizer", "Lcom/github/iielse/imageviewer/core/OverlayCustomizer;", "transformer", "Lcom/github/iielse/imageviewer/core/Transformer;", "vhCustomizer", "Lcom/github/iielse/imageviewer/core/VHCustomizer;", "viewerCallback", "Lcom/github/iielse/imageviewer/core/ViewerCallback;", "working", "getWorking", "()Z", "", "release", "requireDataProvider", "requireImageLoader", "requireInitKey", "requireOverlayCustomizer", "requireTransformer", "requireVHCustomizer", "requireViewerCallback", "setOverlayCustomizer", "setVHCustomizer", "setViewerCallback", "imageviewer_release"})
public final class Components {
    private static boolean initialize;
    private static ImageLoader imageLoader;
    private static DataProvider dataProvider;
    private static Transformer transformer;
    private static Long initKey;
    private static VHCustomizer vhCustomizer;
    private static OverlayCustomizer overlayCustomizer;
    private static ViewerCallback viewerCallback;
    public static final Components INSTANCE;

    public final boolean getWorking() {
        return initialize;
    }

    public final void initialize(@NotNull ImageLoader imageLoader, @NotNull DataProvider dataProvider2, @NotNull Transformer transformer2, long initKey2) {
        Intrinsics.checkParameterIsNotNull((Object)imageLoader, (String)"imageLoader");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider2, (String)"dataProvider");
        Intrinsics.checkParameterIsNotNull((Object)transformer2, (String)"transformer");
        if (Config.INSTANCE.getDEBUG()) {
            Log.i((String)"viewer", (String)"Components initialize");
        }
        if (initialize) {
            throw (Throwable)new IllegalStateException();
        }
        Components.imageLoader = imageLoader;
        dataProvider = dataProvider2;
        transformer = transformer2;
        initKey = initKey2;
        initialize = true;
    }

    public final void setVHCustomizer(@Nullable VHCustomizer vhCustomizer) {
        Components.vhCustomizer = vhCustomizer;
    }

    public final void setViewerCallback(@Nullable ViewerCallback viewerCallback) {
        Components.viewerCallback = viewerCallback;
    }

    public final void setOverlayCustomizer(@Nullable OverlayCustomizer overlayCustomizer) {
        Components.overlayCustomizer = overlayCustomizer;
    }

    @NotNull
    public final ImageLoader requireImageLoader() {
        ImageLoader imageLoader = Components.imageLoader;
        if (imageLoader == null) {
            imageLoader = new ImageLoader(){

                public void load(@NotNull ImageView view, @NotNull Photo data, @NotNull RecyclerView.ViewHolder viewHolder) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    ImageLoader.DefaultImpls.load((ImageLoader)this, view, data, viewHolder);
                }

                public void load(@NotNull SubsamplingScaleImageView subsamplingView, @NotNull Photo data, @NotNull RecyclerView.ViewHolder viewHolder) {
                    Intrinsics.checkParameterIsNotNull((Object)subsamplingView, (String)"subsamplingView");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    ImageLoader.DefaultImpls.load((ImageLoader)this, subsamplingView, data, viewHolder);
                }

                public void load(@NotNull ExoVideoView2 exoVideoView, @NotNull Photo data, @NotNull RecyclerView.ViewHolder viewHolder) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)exoVideoView), (String)"exoVideoView");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    ImageLoader.DefaultImpls.load((ImageLoader)this, exoVideoView, data, viewHolder);
                }
            };
        }
        return imageLoader;
    }

    @NotNull
    public final DataProvider requireDataProvider() {
        DataProvider dataProvider2 = dataProvider;
        if (dataProvider2 == null) {
            dataProvider2 = new DataProvider(){

                @NotNull
                public List<Photo> loadInitial() {
                    return DataProvider.DefaultImpls.loadInitial(this);
                }

                public void loadAfter(long key, @NotNull Function1<? super List<? extends Photo>, Unit> callback2) {
                    Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
                    DataProvider.DefaultImpls.loadAfter(this, key, callback2);
                }

                public void loadBefore(long key, @NotNull Function1<? super List<? extends Photo>, Unit> callback2) {
                    Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
                    DataProvider.DefaultImpls.loadBefore(this, key, callback2);
                }
            };
        }
        return dataProvider2;
    }

    @NotNull
    public final Transformer requireTransformer() {
        Transformer transformer2 = transformer;
        if (transformer2 == null) {
            transformer2 = new Transformer(){

                @Nullable
                public ImageView getView(long key) {
                    return Transformer.DefaultImpls.getView(this, key);
                }
            };
        }
        return transformer2;
    }

    public final long requireInitKey() {
        Long l = initKey;
        return l != null ? l : 0L;
    }

    @NotNull
    public final VHCustomizer requireVHCustomizer() {
        VHCustomizer vHCustomizer = vhCustomizer;
        if (vHCustomizer == null) {
            vHCustomizer = new VHCustomizer(){

                public void initialize(int type, @NotNull RecyclerView.ViewHolder viewHolder) {
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    VHCustomizer.DefaultImpls.initialize(this, type, viewHolder);
                }

                public void bind(int type, @NotNull Photo data, @NotNull RecyclerView.ViewHolder viewHolder) {
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    VHCustomizer.DefaultImpls.bind(this, type, data, viewHolder);
                }
            };
        }
        return vHCustomizer;
    }

    @NotNull
    public final ViewerCallback requireViewerCallback() {
        ViewerCallback viewerCallback = Components.viewerCallback;
        if (viewerCallback == null) {
            viewerCallback = new ViewerCallback(){

                public void onInit(@NotNull RecyclerView.ViewHolder viewHolder) {
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    ViewerCallback.DefaultImpls.onInit(this, viewHolder);
                }

                public void onDrag(@NotNull RecyclerView.ViewHolder viewHolder, @NotNull View view, float fraction) {
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    ViewerCallback.DefaultImpls.onDrag(this, viewHolder, view, fraction);
                }

                public void onRestore(@NotNull RecyclerView.ViewHolder viewHolder, @NotNull View view, float fraction) {
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    ViewerCallback.DefaultImpls.onRestore(this, viewHolder, view, fraction);
                }

                public void onRelease(@NotNull RecyclerView.ViewHolder viewHolder, @NotNull View view) {
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    ViewerCallback.DefaultImpls.onRelease(this, viewHolder, view);
                }

                public void onPageScrollStateChanged(int state) {
                    ViewerCallback.DefaultImpls.onPageScrollStateChanged(this, state);
                }

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                    ViewerCallback.DefaultImpls.onPageScrolled(this, position, positionOffset, positionOffsetPixels);
                }

                public void onPageSelected(int position, @NotNull RecyclerView.ViewHolder viewHolder) {
                    Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                    ViewerCallback.DefaultImpls.onPageSelected(this, position, viewHolder);
                }
            };
        }
        return viewerCallback;
    }

    @NotNull
    public final OverlayCustomizer requireOverlayCustomizer() {
        OverlayCustomizer overlayCustomizer = Components.overlayCustomizer;
        if (overlayCustomizer == null) {
            overlayCustomizer = new OverlayCustomizer(){

                @Nullable
                public View provideView(@NotNull ViewGroup parent) {
                    Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
                    return OverlayCustomizer.DefaultImpls.provideView(this, parent);
                }
            };
        }
        return overlayCustomizer;
    }

    public final void release() {
        if (Config.INSTANCE.getDEBUG()) {
            Log.i((String)"viewer", (String)"Components release");
        }
        initialize = false;
        imageLoader = null;
        dataProvider = null;
        transformer = null;
        initKey = null;
        vhCustomizer = null;
        viewerCallback = null;
        overlayCustomizer = null;
    }

    private Components() {
    }

    static {
        Components components;
        INSTANCE = components = new Components();
    }
}

