/*
 * Decompiled with CFR 0.152.
 */
package com.ihsanbal.logging;

import com.ihsanbal.logging.BufferListener;
import com.ihsanbal.logging.Level;
import com.ihsanbal.logging.LogSink;
import com.ihsanbal.logging.Logger;
import com.ihsanbal.logging.Printer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0014B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/ihsanbal/logging/LoggingInterceptor;", "Lokhttp3/Interceptor;", "builder", "Lcom/ihsanbal/logging/LoggingInterceptor$Builder;", "<init>", "(Lcom/ihsanbal/logging/LoggingInterceptor$Builder;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "printlnResponseLog", "", "receivedMs", "", "response", "request", "Lokhttp3/Request;", "printlnRequestLog", "proceedResponse", "addQueryAndHeaders", "Builder", "lib"})
@SourceDebugExtension(value={"SMAP\nLoggingInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingInterceptor.kt\ncom/ihsanbal/logging/LoggingInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n1869#2,2:284\n1869#2,2:286\n*S KotlinDebug\n*F\n+ 1 LoggingInterceptor.kt\ncom/ihsanbal/logging/LoggingInterceptor\n*L\n87#1:284,2\n94#1:286,2\n*E\n"})
public final class LoggingInterceptor
implements Interceptor {
    @NotNull
    private final Builder builder;

    private LoggingInterceptor(Builder builder) {
        this.builder = builder;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = this.addQueryAndHeaders(chain.request());
        if (this.builder.getLevel() == Level.NONE) {
            return chain.proceed(request);
        }
        this.printlnRequestLog(request);
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = this.proceedResponse(chain, request);
        }
        catch (Exception e) {
            StringBuilder stringBuilder;
            StringBuilder $this$intercept_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$intercept_u24lambda_u240.append(e.getClass().getSimpleName());
            CharSequence charSequence = e.getMessage();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                $this$intercept_u24lambda_u240.append(": ");
                $this$intercept_u24lambda_u240.append(e.getMessage());
            }
            String reason = stringBuilder.toString();
            Printer.Companion.printFailed(this.builder.getTag(false), this.builder, request.url().toString(), reason);
            throw e;
        }
        long receivedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        this.printlnResponseLog(receivedMs, response, request);
        return response;
    }

    private final void printlnResponseLog(long receivedMs, Response response, Request request) {
        Printer.Companion.printJsonResponse(this.builder, receivedMs, response.isSuccessful(), response.code(), response.headers(), response, request.url().encodedPathSegments(), response.message(), request.url().toString());
    }

    private final void printlnRequestLog(Request request) {
        RequestBody requestBody = request.body();
        String string = request.url().url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Printer.Companion.printJsonRequest(this.builder, requestBody, string, request.headers(), request.method());
    }

    private final Response proceedResponse(Interceptor.Chain chain, Request request) {
        Response response;
        if (this.builder.isMockEnabled() && this.builder.getListener() != null) {
            TimeUnit.MILLISECONDS.sleep(this.builder.getSleepMs());
            Response.Builder builder = new Response.Builder();
            BufferListener bufferListener = this.builder.getListener();
            Intrinsics.checkNotNull((Object)bufferListener);
            String string = bufferListener.getJsonResponse(request);
            response = builder.body(string != null ? ResponseBody.Companion.create(string, MediaType.Companion.parse("application/json")) : null).request(chain.request()).protocol(Protocol.HTTP_2).message("Mock data from LoggingInterceptor").code(200).build();
        } else {
            response = chain.proceed(request);
        }
        return response;
    }

    private final Request addQueryAndHeaders(Request request) {
        HttpUrl.Builder httpUrlBuilder;
        Request.Builder requestBuilder = request.newBuilder();
        Set<String> set = this.builder.getHeaders().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            String key = (String)element$iv;
            boolean bl = false;
            if (this.builder.getHeaders().get(key) == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)key);
            requestBuilder.addHeader(key, it);
        }
        HttpUrl.Builder builder = httpUrlBuilder = request.url().newBuilder(request.url().toString());
        if (builder != null) {
            HttpUrl.Builder it = builder;
            boolean bl = false;
            Set<String> set2 = this.builder.getHttpUrl().keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
            Iterable $this$forEach$iv2 = set2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String key = (String)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)key);
                httpUrlBuilder.addQueryParameter(key, this.builder.getHttpUrl().get(key));
            }
        }
        HttpUrl.Builder builder2 = httpUrlBuilder;
        Object object = builder2 != null ? builder2.build() : null;
        Intrinsics.checkNotNull((Object)object);
        return requestBuilder.url(object).build();
    }

    public /* synthetic */ LoggingInterceptor(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 I2\u00020\u0001:\u0001IB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u00104\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\fJ\u0016\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u00109\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0006J\u0010\u0010;\u001a\u00020\u00002\b\u0010:\u001a\u0004\u0018\u00010\u0006J\u0010\u0010<\u001a\u00020\u00002\b\u0010:\u001a\u0004\u0018\u00010\u0006J\u0010\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\fH\u0007J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cJ\u0012\u0010@\u001a\u00020\u00002\b\u0010@\u001a\u0004\u0018\u00010AH\u0007J \u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\f2\u0006\u0010D\u001a\u00020)2\b\u0010.\u001a\u0004\u0018\u00010/J\u0010\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\fH\u0007J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u0006\u0010G\u001a\u00020HR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000e\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000e\"\u0004\b'\u0010\u0011R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006J"}, d2={"Lcom/ihsanbal/logging/LoggingInterceptor$Builder;", "", "<init>", "()V", "headers", "Ljava/util/HashMap;", "", "getHeaders", "()Ljava/util/HashMap;", "httpUrl", "getHttpUrl", "value", "", "isLogHackEnable", "()Z", "isDebugAble", "setDebugAble", "(Z)V", "", "type", "getType", "()I", "requestTag", "responseTag", "Lcom/ihsanbal/logging/Level;", "level", "getLevel", "()Lcom/ihsanbal/logging/Level;", "Lcom/ihsanbal/logging/Logger;", "logger", "getLogger", "()Lcom/ihsanbal/logging/Logger;", "sink", "Lcom/ihsanbal/logging/LogSink;", "getSink", "()Lcom/ihsanbal/logging/LogSink;", "setSink", "(Lcom/ihsanbal/logging/LogSink;)V", "isMockEnabled", "setMockEnabled", "sleepMs", "", "getSleepMs", "()J", "setSleepMs", "(J)V", "listener", "Lcom/ihsanbal/logging/BufferListener;", "getListener", "()Lcom/ihsanbal/logging/BufferListener;", "setListener", "(Lcom/ihsanbal/logging/BufferListener;)V", "setLevel", "getTag", "isRequest", "addHeader", "name", "addQueryParam", "tag", "request", "response", "loggable", "isDebug", "log", "executor", "Ljava/util/concurrent/Executor;", "enableMock", "useMock", "sleep", "enableAndroidStudioV3LogsHack", "useHack", "build", "Lcom/ihsanbal/logging/LoggingInterceptor;", "Companion", "lib"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HashMap<String, String> headers = new HashMap();
        @NotNull
        private final HashMap<String, String> httpUrl = new HashMap();
        private boolean isLogHackEnable;
        private boolean isDebugAble;
        private int type = 4;
        @Nullable
        private String requestTag;
        @Nullable
        private String responseTag;
        @NotNull
        private Level level = Level.BASIC;
        @Nullable
        private Logger logger;
        @Nullable
        private LogSink sink;
        private boolean isMockEnabled;
        private long sleepMs;
        @Nullable
        private BufferListener listener;
        private static final int DEFAULT_LOG_TYPE = 4;
        @NotNull
        private static String TAG = "LoggingI";

        @NotNull
        public final HashMap<String, String> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final HashMap<String, String> getHttpUrl() {
            return this.httpUrl;
        }

        public final boolean isLogHackEnable() {
            return this.isLogHackEnable;
        }

        public final boolean isDebugAble() {
            return this.isDebugAble;
        }

        public final void setDebugAble(boolean bl) {
            this.isDebugAble = bl;
        }

        public final int getType() {
            return this.type;
        }

        @NotNull
        public final Level getLevel() {
            return this.level;
        }

        @Nullable
        public final Logger getLogger() {
            return this.logger;
        }

        @Nullable
        public final LogSink getSink() {
            return this.sink;
        }

        public final void setSink(@Nullable LogSink logSink) {
            this.sink = logSink;
        }

        public final boolean isMockEnabled() {
            return this.isMockEnabled;
        }

        public final void setMockEnabled(boolean bl) {
            this.isMockEnabled = bl;
        }

        public final long getSleepMs() {
            return this.sleepMs;
        }

        public final void setSleepMs(long l) {
            this.sleepMs = l;
        }

        @Nullable
        public final BufferListener getListener() {
            return this.listener;
        }

        public final void setListener(@Nullable BufferListener bufferListener) {
            this.listener = bufferListener;
        }

        @NotNull
        public final Builder setLevel(@NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            this.level = level;
            return this;
        }

        @NotNull
        public final String getTag(boolean isRequest) {
            String string;
            boolean bl = isRequest;
            if (bl) {
                CharSequence charSequence = this.requestTag;
                if (charSequence == null || charSequence.length() == 0) {
                    string = TAG;
                } else {
                    String string2 = this.requestTag;
                    string = string2;
                    Intrinsics.checkNotNull((Object)string2);
                }
            } else if (!bl) {
                CharSequence charSequence = this.responseTag;
                if (charSequence == null || charSequence.length() == 0) {
                    string = TAG;
                } else {
                    String string3 = this.responseTag;
                    string = string3;
                    Intrinsics.checkNotNull((Object)string3);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @NotNull
        public final Builder addHeader(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ((Map)this.headers).put(name, value);
            return this;
        }

        @NotNull
        public final Builder addQueryParam(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ((Map)this.httpUrl).put(name, value);
            return this;
        }

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            TAG = tag;
            return this;
        }

        @NotNull
        public final Builder request(@Nullable String tag) {
            this.requestTag = tag;
            return this;
        }

        @NotNull
        public final Builder response(@Nullable String tag) {
            this.responseTag = tag;
            return this;
        }

        @Deprecated(message="Set level based on your requirement", replaceWith=@ReplaceWith(expression="setLevel(Level.Basic)", imports={}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder loggable(boolean isDebug) {
            this.isDebugAble = isDebug;
            return this;
        }

        @NotNull
        public final Builder log(int type) {
            this.type = type;
            return this;
        }

        @NotNull
        public final Builder logger(@Nullable Logger logger) {
            this.logger = logger;
            return this;
        }

        @Deprecated(message="Create your own Logcat filter for best result", level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder executor(@Nullable Executor executor) {
            String string = "Deprecated";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public final Builder enableMock(boolean useMock, long sleep, @Nullable BufferListener listener) {
            this.isMockEnabled = useMock;
            this.sleepMs = sleep;
            this.listener = listener;
            return this;
        }

        @Deprecated(message="Android studio has resolved problem for latest versions", level=DeprecationLevel.WARNING)
        @NotNull
        public final Builder enableAndroidStudioV3LogsHack(boolean useHack) {
            this.isLogHackEnable = useHack;
            return this;
        }

        @NotNull
        public final Builder sink(@NotNull LogSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            this.sink = sink;
            return this;
        }

        @NotNull
        public final LoggingInterceptor build() {
            return new LoggingInterceptor(this, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/ihsanbal/logging/LoggingInterceptor$Builder$Companion;", "", "<init>", "()V", "DEFAULT_LOG_TYPE", "", "TAG", "", "lib"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

