/*
 * Decompiled with CFR 0.152.
 */
package com.ihsanbal.logging;

import com.ihsanbal.logging.LogSink;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0010\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/ihsanbal/logging/I;", "", "<init>", "()V", "Companion", "lib"})
public class I {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] prefix;
    private static int index;

    protected I() {
        throw new UnsupportedOperationException();
    }

    static {
        String[] stringArray = new String[]{". ", " ."};
        prefix = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\"\u0010\u0013\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ihsanbal/logging/I$Companion;", "", "<init>", "()V", "prefix", "", "", "[Ljava/lang/String;", "index", "", "log", "", "type", "tag", "msg", "isLogHackEnable", "", "sink", "Lcom/ihsanbal/logging/LogSink;", "logWithAndroid", "mapJavaLevel", "Ljava/util/logging/Level;", "getFinalTag", "lib"})
    public static final class Companion {
        private Companion() {
        }

        public final void log(int type, @NotNull String tag, @Nullable String msg, boolean isLogHackEnable, @Nullable LogSink sink) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            if (sink != null) {
                String string = msg;
                if (string == null) {
                    string = "";
                }
                sink.log(type, tag, string);
                return;
            }
            String finalTag = this.getFinalTag(tag, isLogHackEnable);
            if (!this.logWithAndroid(type, finalTag, msg)) {
                Logger logger = Logger.getLogger(isLogHackEnable ? finalTag : tag);
                logger.log(this.mapJavaLevel(type), msg);
            }
        }

        public static /* synthetic */ void log$default(Companion companion, int n, String string, String string2, boolean bl, LogSink logSink, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                logSink = null;
            }
            companion.log(n, string, string2, bl, logSink);
        }

        private final boolean logWithAndroid(int type, String tag, String msg) {
            boolean bl;
            try {
                Class<?> logClass = Class.forName("android.util.Log");
                Object[] objectArray = new Class[]{Integer.TYPE, String.class, String.class};
                Method printlnMethod = logClass.getMethod("println", (Class<?>[])objectArray);
                objectArray = new Object[3];
                objectArray[0] = type;
                objectArray[1] = tag;
                String string = msg;
                if (string == null) {
                    string = "";
                }
                objectArray[2] = string;
                printlnMethod.invoke(null, objectArray);
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
            }
            return bl;
        }

        private final Level mapJavaLevel(int type) {
            Level level;
            switch (type) {
                case 2: 
                case 3: {
                    Level level2 = Level.FINE;
                    level = level2;
                    Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINE");
                    break;
                }
                case 4: {
                    Level level3 = Level.INFO;
                    level = level3;
                    Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"INFO");
                    break;
                }
                case 5: {
                    Level level4 = Level.WARNING;
                    level = level4;
                    Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"WARNING");
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    Level level5 = Level.SEVERE;
                    level = level5;
                    Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"SEVERE");
                    break;
                }
                default: {
                    Level level6 = Level.INFO;
                    level = level6;
                    Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"INFO");
                }
            }
            return level;
        }

        private final String getFinalTag(String tag, boolean isLogHackEnable) {
            String string;
            if (isLogHackEnable) {
                index = index ^ 1;
                string = prefix[index] + tag;
            } else {
                string = tag;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

