/*
 * Decompiled with CFR 0.152.
 */
package com.ihsanbal.logging;

import com.ihsanbal.logging.I;
import com.ihsanbal.logging.Level;
import com.ihsanbal.logging.Logger;
import com.ihsanbal.logging.LoggingInterceptor;
import com.ihsanbal.logging.PrinterKt;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/ihsanbal/logging/Printer;", "", "()V", "Companion", "lib"})
public final class Printer {
    private static final int JSON_INDENT = 3;
    private static final String LINE_SEPARATOR;
    private static final String DOUBLE_SEPARATOR;
    private static final String N = "\n";
    private static final String T = "\t";
    private static final String REQUEST_UP_LINE = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500 Request \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String END_LINE = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String RESPONSE_UP_LINE = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500 Response \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String BODY_TAG = "Body:";
    private static final String URL_TAG = "URL: ";
    private static final String METHOD_TAG = "Method: @";
    private static final String HEADERS_TAG = "Headers:";
    private static final String STATUS_CODE_TAG = "Status Code: ";
    private static final String RECEIVED_TAG = "Received in: ";
    private static final String DEFAULT_LINE = "\u2502 ";
    private static final String OOM_OMITTED;
    public static final Companion Companion;

    private Printer() {
        throw (Throwable)new UnsupportedOperationException();
    }

    static {
        Companion = new Companion(null);
        LINE_SEPARATOR = System.getProperty("line.separator");
        DOUBLE_SEPARATOR = LINE_SEPARATOR + LINE_SEPARATOR;
        OOM_OMITTED = LINE_SEPARATOR + "Output omitted because of Object size.";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J+\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010%JQ\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010-\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u0004H\u0002JE\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\u00042\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040!2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010=J\u0016\u0010>\u001a\u0002052\u0006\u00107\u001a\u00020\u00042\u0006\u0010?\u001a\u00020@J0\u0010A\u001a\u0002052\u0006\u0010?\u001a\u00020@2\b\u0010B\u001a\u0004\u0018\u00010\u001c2\u0006\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0004JT\u0010E\u001a\u0002052\u0006\u0010?\u001a\u00020@2\u0006\u0010F\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00100\u001a\u0002012\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0004J\u0016\u0010H\u001a\u00020\u00042\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040,H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/ihsanbal/logging/Printer$Companion;", "", "()V", "BODY_TAG", "", "DEFAULT_LINE", "DOUBLE_SEPARATOR", "END_LINE", "HEADERS_TAG", "JSON_INDENT", "", "LINE_SEPARATOR", "kotlin.jvm.PlatformType", "METHOD_TAG", "N", "OOM_OMITTED", "RECEIVED_TAG", "REQUEST_UP_LINE", "RESPONSE_UP_LINE", "STATUS_CODE_TAG", "T", "URL_TAG", "bodyHasUnknownEncoding", "", "headers", "Lokhttp3/Headers;", "bodyToString", "requestBody", "Lokhttp3/RequestBody;", "dotHeaders", "getJsonString", "msg", "getRequest", "", "level", "Lcom/ihsanbal/logging/Level;", "method", "(Lcom/ihsanbal/logging/Level;Lokhttp3/Headers;Ljava/lang/String;)[Ljava/lang/String;", "getResponse", "tookMs", "", "code", "isSuccessful", "segments", "", "message", "(Lokhttp3/Headers;JIZLcom/ihsanbal/logging/Level;Ljava/util/List;Ljava/lang/String;)[Ljava/lang/String;", "getResponseBody", "response", "Lokhttp3/Response;", "isEmpty", "line", "logLines", "", "type", "tag", "lines", "logger", "Lcom/ihsanbal/logging/Logger;", "withLineSize", "useLogHack", "(ILjava/lang/String;[Ljava/lang/String;Lcom/ihsanbal/logging/Logger;ZZ)V", "printFailed", "builder", "Lcom/ihsanbal/logging/LoggingInterceptor$Builder;", "printJsonRequest", "body", "url", "header", "printJsonResponse", "chainMs", "responseUrl", "slashSegments", "lib"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEmpty(String line) {
            CharSequence charSequence = line;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            if (Intrinsics.areEqual((Object)Printer.N, (Object)line)) return true;
            if (Intrinsics.areEqual((Object)Printer.T, (Object)line)) return true;
            String $this$trim$iv = line;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl3 = false;
                boolean bl4 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            bl = false;
            if (charSequence.length() != 0) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void printJsonRequest(@NotNull LoggingInterceptor.Builder builder, @Nullable RequestBody body, @NotNull String url, @NotNull Headers header, @NotNull String method) {
            Object object;
            block8: {
                block7: {
                    Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                    Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                    object = body;
                    if (object == null) break block7;
                    RequestBody requestBody = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    RequestBody it = requestBody;
                    boolean bl3 = false;
                    object = LINE_SEPARATOR + Printer.BODY_TAG + LINE_SEPARATOR + Companion.bodyToString(body, header);
                    if (object != null) break block8;
                }
                object = "";
            }
            Object requestBody = object;
            String tag = builder.getTag(true);
            if (builder.getLogger() == null) {
                I.Companion.log(builder.getType(), tag, Printer.REQUEST_UP_LINE, builder.isLogHackEnable());
            }
            this.logLines(builder.getType(), tag, new String[]{Printer.URL_TAG + url}, builder.getLogger(), false, builder.isLogHackEnable());
            this.logLines(builder.getType(), tag, this.getRequest(builder.getLevel(), header, method), builder.getLogger(), true, builder.isLogHackEnable());
            if (builder.getLevel() == Level.BASIC || builder.getLevel() == Level.BODY) {
                void $this$toTypedArray$iv;
                int n = builder.getType();
                CharSequence charSequence = (CharSequence)requestBody;
                String[] stringArray = new String[1];
                String string = LINE_SEPARATOR;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LINE_SEPARATOR");
                stringArray[0] = string;
                Collection collection = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String string2 = tag;
                int n2 = n;
                Companion companion = this;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray3 = stringArray2;
                companion.logLines(n2, string2, stringArray3, builder.getLogger(), true, builder.isLogHackEnable());
            }
            if (builder.getLogger() == null) {
                I.Companion.log(builder.getType(), tag, Printer.END_LINE, builder.isLogHackEnable());
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void printJsonResponse(@NotNull LoggingInterceptor.Builder builder, long chainMs, boolean isSuccessful, int code, @NotNull Headers headers, @NotNull Response response, @NotNull List<String> segments, @NotNull String message, @NotNull String responseUrl) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            Intrinsics.checkParameterIsNotNull(segments, (String)"segments");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)responseUrl, (String)"responseUrl");
            String responseBody = LINE_SEPARATOR + Printer.BODY_TAG + LINE_SEPARATOR + this.getResponseBody(response);
            String tag = builder.getTag(false);
            String[] urlLine = new String[]{Printer.URL_TAG + responseUrl, Printer.N};
            String[] responseString = this.getResponse(headers, chainMs, code, isSuccessful, builder.getLevel(), segments, message);
            if (builder.getLogger() == null) {
                I.Companion.log(builder.getType(), tag, Printer.RESPONSE_UP_LINE, builder.isLogHackEnable());
            }
            this.logLines(builder.getType(), tag, urlLine, builder.getLogger(), true, builder.isLogHackEnable());
            this.logLines(builder.getType(), tag, responseString, builder.getLogger(), true, builder.isLogHackEnable());
            if (builder.getLevel() == Level.BASIC || builder.getLevel() == Level.BODY) {
                void $this$toTypedArray$iv;
                int n = builder.getType();
                CharSequence charSequence = responseBody;
                String[] stringArray = new String[1];
                String string = LINE_SEPARATOR;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LINE_SEPARATOR");
                stringArray[0] = string;
                Collection collection = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String string2 = tag;
                int n2 = n;
                Companion companion = this;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray3 = stringArray2;
                companion.logLines(n2, string2, stringArray3, builder.getLogger(), true, builder.isLogHackEnable());
            }
            if (builder.getLogger() == null) {
                I.Companion.log(builder.getType(), tag, Printer.END_LINE, builder.isLogHackEnable());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String getResponseBody(Response response) {
            MediaType contentType;
            Object object;
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                Intrinsics.throwNpe();
            }
            ResponseBody responseBody2 = responseBody;
            Headers headers = response.headers();
            long contentLength = responseBody2.contentLength();
            if (!HttpHeaders.promisesBody((Response)response)) {
                return "End request - Promises Body";
            }
            if (this.bodyHasUnknownEncoding(response.headers())) {
                return "encoded body omitted";
            }
            BufferedSource source = responseBody2.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.getBuffer();
            Long gzippedLength = null;
            if (StringsKt.equals((String)"gzip", (String)headers.get("Content-Encoding"), (boolean)true)) {
                gzippedLength = buffer.size();
                Closeable closeable = (Closeable)new GzipSource((Source)buffer.clone());
                boolean bl = false;
                Throwable throwable = null;
                try {
                    GzipSource gzippedResponseBody = (GzipSource)closeable;
                    boolean bl2 = false;
                    buffer = new Buffer();
                    long l = buffer.writeAll((Source)gzippedResponseBody);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            if ((object = (contentType = responseBody2.contentType())) == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                Charset charset = StandardCharsets.UTF_8;
                object = charset;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            }
            Object charset = object;
            if (!PrinterKt.isProbablyUtf8(buffer)) {
                return "End request - binary " + buffer.size() + ":byte body omitted";
            }
            if (contentLength != 0L) {
                return this.getJsonString(buffer.clone().readString((Charset)charset));
            }
            return gzippedLength != null ? "End request - " + buffer.size() + ":byte, " + gzippedLength + "-gzipped-byte body" : "End request - " + buffer.size() + ":byte body";
        }

        private final String[] getRequest(Level level, Headers headers, String method) {
            String log = null;
            boolean loggableHeader = level == Level.HEADERS || level == Level.BASIC;
            log = Printer.METHOD_TAG + method + DOUBLE_SEPARATOR + (this.isEmpty(String.valueOf(headers)) ? "" : (loggableHeader ? Printer.HEADERS_TAG + LINE_SEPARATOR + this.dotHeaders(headers) : ""));
            CharSequence charSequence = log;
            String[] stringArray = new String[1];
            String string = LINE_SEPARATOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LINE_SEPARATOR");
            stringArray[0] = string;
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray2;
        }

        private final String[] getResponse(Headers headers, long tookMs, int code, boolean isSuccessful, Level level, List<String> segments, String message) {
            String log = null;
            boolean loggableHeader = level == Level.HEADERS || level == Level.BASIC;
            String segmentString = this.slashSegments(segments);
            CharSequence charSequence = segmentString;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            log = stringBuilder.append(bl2 ? segmentString + " - " : "").append("[is success : ").append(isSuccessful).append("] - ").append(Printer.RECEIVED_TAG).append(tookMs).append("ms").append(DOUBLE_SEPARATOR).append(Printer.STATUS_CODE_TAG).append(code).append(" / ").append(message).append(DOUBLE_SEPARATOR).append(this.isEmpty(String.valueOf(headers)) ? "" : (loggableHeader ? Printer.HEADERS_TAG + LINE_SEPARATOR + this.dotHeaders(headers) : "")).toString();
            CharSequence charSequence2 = log;
            String[] stringArray = new String[1];
            String string = LINE_SEPARATOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LINE_SEPARATOR");
            stringArray[0] = string;
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray2;
        }

        private final String slashSegments(List<String> segments) {
            StringBuilder segmentString = new StringBuilder();
            for (String segment : segments) {
                segmentString.append("/").append(segment);
            }
            String string = segmentString.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"segmentString.toString()");
            return string;
        }

        private final String dotHeaders(Headers headers) {
            StringBuilder builder = new StringBuilder();
            Iterable $this$forEach$iv = (Iterable)headers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                builder.append((String)pair.getFirst() + ": " + (String)pair.getSecond()).append(Printer.N);
            }
            return ((Object)StringsKt.dropLast((CharSequence)builder, (int)1)).toString();
        }

        /*
         * WARNING - void declaration
         */
        private final void logLines(int type, String tag, String[] lines, Logger logger, boolean withLineSize, boolean useLogHack) {
            String[] stringArray = lines;
            int n = stringArray.length;
            block0: for (int i = 0; i < n; ++i) {
                int maxLogSize;
                int n2 = 0;
                String line = stringArray[i];
                int lineLength = line.length();
                int n3 = lineLength / (maxLogSize = withLineSize ? 110 : lineLength);
                if (n2 > n3) continue;
                while (true) {
                    boolean bl;
                    Object object;
                    int n4;
                    String string;
                    CharSequence charSequence;
                    String string2;
                    void i2;
                    void start = i2 * maxLogSize;
                    int end = (i2 + true) * maxLogSize;
                    int n5 = end = end > line.length() ? line.length() : end;
                    if (logger == null) {
                        String string3;
                        string2 = line;
                        charSequence = new StringBuilder().append(Printer.DEFAULT_LINE);
                        string = tag;
                        n4 = type;
                        object = I.Companion;
                        bl = false;
                        String string4 = string2;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring((int)start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        ((I.Companion)object).log(n4, string, ((StringBuilder)charSequence).append(string3).toString(), useLogHack);
                    } else {
                        string2 = line;
                        string = tag;
                        n4 = type;
                        object = logger;
                        bl = false;
                        String string5 = string2;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring((int)start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        object.log(n4, string, (String)charSequence);
                    }
                    if (i2 == n3) continue block0;
                    ++i2;
                }
            }
        }

        private final String bodyToString(RequestBody requestBody, Headers headers) {
            RequestBody requestBody2 = requestBody;
            if (requestBody2 != null) {
                RequestBody requestBody3 = requestBody2;
                boolean bl = false;
                boolean bl2 = false;
                RequestBody it = requestBody3;
                boolean bl3 = false;
                try {
                    if (Companion.bodyHasUnknownEncoding(headers)) {
                        return "encoded body omitted)";
                    }
                    if (requestBody.isDuplex()) {
                        return "duplex request body omitted";
                    }
                    if (requestBody.isOneShot()) {
                        return "one-shot body omitted";
                    }
                    Buffer buffer = new Buffer();
                    requestBody.writeTo((BufferedSink)buffer);
                    MediaType contentType = requestBody.contentType();
                    Object object = contentType;
                    if (object == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                        Charset charset = StandardCharsets.UTF_8;
                        object = charset;
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                    }
                    Object charset = object;
                    return PrinterKt.isProbablyUtf8(buffer) ? Companion.getJsonString(buffer.readString((Charset)charset)) + LINE_SEPARATOR + requestBody.contentLength() + "-byte body" : "binary " + requestBody.contentLength() + "-byte body omitted";
                }
                catch (IOException e) {
                    String string = "{\"err\": \"" + e.getMessage() + "\"}";
                    return string;
                }
            }
            return "";
        }

        private final boolean bodyHasUnknownEncoding(Headers headers) {
            String string = headers.get("Content-Encoding");
            if (string == null) {
                return false;
            }
            String contentEncoding = string;
            return !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
        }

        private final String getJsonString(String msg) {
            String string;
            String message = null;
            try {
                String string2;
                if (StringsKt.startsWith$default((String)msg, (String)"{", (boolean)false, (int)2, null)) {
                    JSONObject jsonObject = new JSONObject(msg);
                    String string3 = jsonObject.toString(3);
                    string2 = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"jsonObject.toString(JSON_INDENT)");
                } else if (StringsKt.startsWith$default((String)msg, (String)"[", (boolean)false, (int)2, null)) {
                    JSONArray jsonArray = new JSONArray(msg);
                    String string4 = jsonArray.toString(3);
                    string2 = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"jsonArray.toString(JSON_INDENT)");
                } else {
                    string2 = msg;
                }
                string = string2;
            }
            catch (JSONException e) {
                string = msg;
            }
            catch (OutOfMemoryError e1) {
                string = OOM_OMITTED;
            }
            message = string;
            return message;
        }

        public final void printFailed(@NotNull String tag, @NotNull LoggingInterceptor.Builder builder) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            I.Companion.log(builder.getType(), tag, Printer.RESPONSE_UP_LINE, builder.isLogHackEnable());
            I.Companion.log(builder.getType(), tag, "\u2502 Response failed", builder.isLogHackEnable());
            I.Companion.log(builder.getType(), tag, Printer.END_LINE, builder.isLogHackEnable());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

