/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.xml.xstream.converters;

import com.feilong.core.Validate;
import com.feilong.core.util.MapUtil;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Map;
import java.util.Objects;

public class SimpleMapConverter
implements Converter {
    public static final SimpleMapConverter INSTANCE = new SimpleMapConverter();

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Validate.notNull(key, "key can't be null!", new Object[0]);
            writer.startNode(Objects.toString(key));
            writer.setValue(Objects.toString(entry.getValue(), ""));
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Map<String, String> map = MapUtil.newLinkedHashMap();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            map.put(reader.getNodeName(), reader.getValue());
            reader.moveUp();
        }
        return map;
    }

    public boolean canConvert(Class clazz) {
        return Map.class.isAssignableFrom(clazz);
    }
}

