/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.xml.xstream;

import com.feilong.core.Validator;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.xml.xstream.XStreamConfig;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public final class XStreamBuilder {
    private static final HierarchicalStreamDriver XPPDRIVER_NONAMECODER = new XppDriver((NameCoder)new NoNameCoder());
    private static final HierarchicalStreamDriver XPPDRIVER_NONAMECODER_COMPACTWRITER = new XppDriver((NameCoder)new NoNameCoder()){

        public HierarchicalStreamWriter createWriter(Writer out) {
            return new CompactWriter(out, this.getNameCoder());
        }
    };

    private XStreamBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static XStream build(XStreamConfig xStreamConfig) {
        XStream xstream = XStreamBuilder.buildDefault(xStreamConfig);
        if (Validator.isNullOrEmpty(xStreamConfig)) {
            return xstream;
        }
        XStreamBuilder.doAlias(xStreamConfig, xstream);
        XStreamBuilder.doAddImplicitCollection(xStreamConfig, xstream);
        XStreamBuilder.doWithConverter(xStreamConfig, xstream);
        XStreamBuilder.doProcessAnnotationsTypes(xStreamConfig, xstream);
        XStreamBuilder.doDefaultImplementationMap(xStreamConfig, xstream);
        return xstream;
    }

    private static void doDefaultImplementationMap(XStreamConfig xStreamConfig, XStream xstream) {
        Map<Class<?>, Class<?>> defaultImplementationMap = xStreamConfig.getDefaultImplementationMap();
        if (Validator.isNotNullOrEmpty(defaultImplementationMap)) {
            for (Map.Entry<Class<?>, Class<?>> entry : defaultImplementationMap.entrySet()) {
                Class<?> defaultImplementation = entry.getKey();
                Class<?> ofType = entry.getValue();
                xstream.addDefaultImplementation(defaultImplementation, ofType);
            }
        }
    }

    private static void doWithConverter(XStreamConfig xStreamConfig, XStream xstream) {
        List<? extends Converter> converterList = xStreamConfig.getConverterList();
        if (Validator.isNotNullOrEmpty(converterList)) {
            for (Converter converter : converterList) {
                xstream.registerConverter(converter);
            }
        }
    }

    private static XStream buildDefault(XStreamConfig xStreamConfig) {
        XStream xstream = new XStream(XStreamBuilder.buildHierarchicalStreamDriver(xStreamConfig));
        xstream.autodetectAnnotations(true);
        xstream.ignoreUnknownElements();
        return xstream;
    }

    private static void doProcessAnnotationsTypes(XStreamConfig xStreamConfig, XStream xstream) {
        Class[] processAnnotationsTypes = xStreamConfig.getProcessAnnotationsTypes();
        if (Validator.isNotNullOrEmpty(processAnnotationsTypes)) {
            xstream.processAnnotations(processAnnotationsTypes);
        }
    }

    private static HierarchicalStreamDriver buildHierarchicalStreamDriver(XStreamConfig xStreamConfig) {
        if (null == xStreamConfig) {
            return XStreamBuilder.defaultDriver(xStreamConfig);
        }
        return ObjectUtil.defaultIfNull(xStreamConfig.getHierarchicalStreamDriver(), XStreamBuilder.defaultDriver(xStreamConfig));
    }

    private static HierarchicalStreamDriver defaultDriver(XStreamConfig xStreamConfig) {
        if (null == xStreamConfig) {
            return XPPDRIVER_NONAMECODER;
        }
        return xStreamConfig.getIsPrettyPrint() ? XPPDRIVER_NONAMECODER : XPPDRIVER_NONAMECODER_COMPACTWRITER;
    }

    private static void doAddImplicitCollection(XStreamConfig xStreamConfig, XStream xstream) {
        Map<String, Class<?>> implicitCollectionMap = xStreamConfig.getImplicitCollectionMap();
        if (Validator.isNullOrEmpty(implicitCollectionMap)) {
            return;
        }
        for (Map.Entry<String, Class<?>> entry : implicitCollectionMap.entrySet()) {
            String key = entry.getKey();
            Class<?> value = entry.getValue();
            xstream.addImplicitCollection(value, key);
        }
    }

    private static void doAlias(XStreamConfig xStreamConfig, XStream xstream) {
        Map<String, Class<?>> aliasMap = xStreamConfig.getAliasMap();
        if (Validator.isNullOrEmpty(aliasMap)) {
            return;
        }
        for (Map.Entry<String, Class<?>> entry : aliasMap.entrySet()) {
            String key = entry.getKey();
            Class<?> value = entry.getValue();
            xstream.alias(key, value);
        }
    }
}

