/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.tools.emailaddress;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.ResourceBundleUtil;
import com.feilong.core.util.SortUtil;
import com.feilong.formatter.FormatterUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.tools.emailaddress.EmailProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmailAddressUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailAddressUtil.class);
    private static final String AT = "@";
    private static final String DELIMITERS = ",;";
    static final Map<String, String> EMAIL_PROVIDER_MAP = ResourceBundleUtil.toMap(ResourceBundleUtil.getResourceBundle("config/feilong-emailProvider"));
    private static Map<String, EmailProvider> domainAndEmailProviderMap = new ConcurrentHashMap<String, EmailProvider>();

    private EmailAddressUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static EmailProvider getEmailProvider(String emailAddress) {
        Validate.notBlank(emailAddress, "emailAddress can't be blank!", new Object[0]);
        String domain = EmailAddressUtil.getDomain(emailAddress);
        return Validator.isNullOrEmpty(domain) ? null : domainAndEmailProviderMap.get(domain.toLowerCase());
    }

    public static String getDomain(String emailAddress) {
        Validate.notBlank(emailAddress, "emailAddress can't be blank!", new Object[0]);
        return StringUtils.substringAfterLast(emailAddress, AT);
    }

    public static String getUser(String emailAddress) {
        Validate.notBlank(emailAddress, "emailAddress can't be blank!", new Object[0]);
        return StringUtil.split(emailAddress, AT)[0];
    }

    private static void init() {
        Validate.notEmpty(EMAIL_PROVIDER_MAP, "EmailServiceProvider properties can't be null/empty!", new Object[0]);
        for (Map.Entry<String, String> entry : EMAIL_PROVIDER_MAP.entrySet()) {
            String key = entry.getKey();
            domainAndEmailProviderMap.put(key.toLowerCase(), EmailAddressUtil.buildEmailProvider(key, entry.getValue()));
        }
        if (LOGGER.isDebugEnabled()) {
            List<EmailProvider> iterable = SortUtil.sortListByPropertyNamesValue(ConvertUtil.toList(domainAndEmailProviderMap.values()), "domain");
            LOGGER.debug("init [data] over,{}", (Object)FormatterUtil.formatToSimpleTable(iterable, "domain", "webSite", "name"));
        }
    }

    private static EmailProvider buildEmailProvider(String key, String value) {
        String[] tokenizeToStringArray = StringUtil.tokenizeToStringArray(value, DELIMITERS);
        return new EmailProvider(key, tokenizeToStringArray[0], tokenizeToStringArray[1]);
    }

    static {
        EmailAddressUtil.init();
    }
}

