/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.template;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import com.feilong.template.VelocityEngineBuilder;
import com.feilong.template.VelocityEngineParser;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTemplateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTemplateUtil.class);
    static final VelocityEngine CLASSPATH_VELOCITY_ENGINE = VelocityEngineBuilder.build("config.feilong-velocity-ClasspathResourceLoader");
    static final VelocityEngine STRING_VELOCITY_ENGINE = VelocityEngineBuilder.build("config.feilong-velocity-StringResourceLoader");

    AbstractTemplateUtil() {
    }

    public String parseTemplateWithClasspathResourceLoader(String templateInClassPath) {
        return this.parseTemplateWithClasspathResourceLoader(templateInClassPath, null);
    }

    public String parseTemplateWithClasspathResourceLoader(String templateInClassPath, Map<String, ?> contextKeyValues) {
        Validate.notBlank(templateInClassPath, "templateInClassPath can't be null/empty!", new Object[0]);
        Context context = this.buildContext(contextKeyValues);
        return VelocityEngineParser.parse(CLASSPATH_VELOCITY_ENGINE, templateInClassPath, context);
    }

    public String parseString(String vmContent, Map<String, ?> contextKeyValues) {
        if (Validator.isNullOrEmpty(vmContent)) {
            return vmContent;
        }
        String templateName = vmContent;
        StringResourceRepository stringResourceRepository = (StringResourceRepository)STRING_VELOCITY_ENGINE.getApplicationAttribute((Object)StringResourceLoader.REPOSITORY_NAME_DEFAULT);
        stringResourceRepository.putStringResource(templateName, vmContent);
        Context context = this.buildContext(contextKeyValues);
        return VelocityEngineParser.parse(STRING_VELOCITY_ENGINE, templateName, context);
    }

    protected abstract Context buildContext(Map<String, ?> var1);

    protected static Map<String, Object> toMap(Map<String, ?> contextKeyValues) {
        if (null == contextKeyValues) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(contextKeyValues);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("will build [{}] use map:[{}]", (Object)Context.class.getName(), (Object)JsonUtil.formatSimpleMap(result));
        }
        return result;
    }
}

