/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.pager;

import com.feilong.core.CharsetType;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.servlet.http.RequestUtil;
import com.feilong.taglib.AbstractStartWriteContentTag;
import com.feilong.taglib.LocaleSupport;
import com.feilong.taglib.display.LocaleSupportUtil;
import com.feilong.taglib.display.pager.PagerBuilder;
import com.feilong.taglib.display.pager.PagerHelper;
import com.feilong.taglib.display.pager.command.PagerParams;
import javax.servlet.http.HttpServletRequest;

public class PagerTag
extends AbstractStartWriteContentTag
implements LocaleSupport {
    private static final long serialVersionUID = -3523064037264688170L;
    private Integer count;
    private Integer pageSize = 20;
    private String pageParamName = "pageNo";
    private String vmPath = "velocity/feilong-default-pager.vm";
    private String skin = "digg";
    private Integer maxShowPageNo = -1;
    private Object locale;
    private String charsetType = CharsetType.UTF8;
    private String pagerHtmlAttributeName;
    private String dynamicNavigationPageNumberConfig = "1000=6&100=8&1=10";

    @Override
    public String buildContent(HttpServletRequest request) {
        PagerParams pagerParams = this.buildPagerParams(request);
        String htmlContent = PagerBuilder.buildContent(pagerParams);
        String name = ObjectUtil.defaultIfNullOrEmpty(this.pagerHtmlAttributeName, "feilongPagerHtml");
        this.pageContext.setAttribute(name, (Object)htmlContent);
        return htmlContent;
    }

    private PagerParams buildPagerParams(HttpServletRequest request) {
        String pageUrl = RequestUtil.getRequestFullURL(request, this.charsetType);
        PagerParams pagerParams = new PagerParams(this.count, pageUrl);
        pagerParams.setCurrentPageNo(PagerHelper.getCurrentPageNo(request, this.pageParamName));
        pagerParams.setPageSize(this.pageSize <= 0 ? 20 : this.pageSize);
        pagerParams.setPageParamName(this.pageParamName);
        pagerParams.setVmPath(this.vmPath);
        pagerParams.setCharsetType(this.charsetType);
        pagerParams.setLocale(LocaleSupportUtil.toLocal(this.locale, request));
        pagerParams.setMaxShowPageNo(this.maxShowPageNo);
        pagerParams.setSkin(this.skin);
        pagerParams.setDynamicNavigationPageNumberConfig(this.dynamicNavigationPageNumberConfig);
        pagerParams.setDebugIsNotParseVM(PagerTag.getDebugIsNotParseVM(request));
        return pagerParams;
    }

    private static boolean getDebugIsNotParseVM(HttpServletRequest request) {
        String parameter = request.getParameter("debugNotParseVM");
        return "true".equals(parameter);
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageParamName(String pageParamName) {
        this.pageParamName = pageParamName;
    }

    public void setVmPath(String vmPath) {
        this.vmPath = vmPath;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public void setMaxShowPageNo(Integer maxShowPageNo) {
        this.maxShowPageNo = maxShowPageNo;
    }

    public void setCharsetType(String charsetType) {
        this.charsetType = charsetType;
    }

    public void setPagerHtmlAttributeName(String pagerHtmlAttributeName) {
        this.pagerHtmlAttributeName = pagerHtmlAttributeName;
    }

    @Override
    public void setLocale(Object locale) {
        this.locale = locale;
    }

    public void setDynamicNavigationPageNumberConfig(String dynamicNavigationPageNumberConfig) {
        this.dynamicNavigationPageNumberConfig = dynamicNavigationPageNumberConfig;
    }
}

