/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.option;

import com.feilong.taglib.display.CacheContentBuilder;
import com.feilong.taglib.display.LocaleSupportUtil;
import com.feilong.taglib.display.option.OptionParam;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.util.Map;

public class OptionCacheContentBuilder
implements CacheContentBuilder<OptionParam, String> {
    public static final CacheContentBuilder<OptionParam, String> INSTANCE = new OptionCacheContentBuilder();
    private static final String OPTION_PATTERN = "<option value=\"{}\"{}>{}</option>";
    private static final String SELECTED_STRING = " selected=\"selected\"";

    @Override
    public String build(OptionParam optionParam) {
        StringBuilder sb = new StringBuilder();
        Map<String, String> map = LocaleSupportUtil.build(optionParam);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String option = OptionCacheContentBuilder.buildOption(entry.getKey(), entry.getValue(), optionParam.getSelectedKey());
            sb.append(option).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static String buildOption(String key, String value, String selectedKey) {
        String selectedStatus = key.equals(selectedKey) ? SELECTED_STRING : "";
        return Slf4jUtil.format(OPTION_PATTERN, key, selectedStatus, value);
    }
}

