/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.httpconcat.handler;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.RegexUtil;
import com.feilong.lib.lang3.StringUtils;

public class ItemSrcExtractor {
    private ItemSrcExtractor() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static String extract(String item, String domain) {
        Validate.notBlank(item, "item can't be blank!", new Object[0]);
        String workItem = item.trim();
        if (workItem.startsWith("<link ")) {
            return ItemSrcExtractor.pickUp(workItem, ".*?href=\"(.*?)\".*?", domain);
        }
        if (workItem.startsWith("<script ")) {
            return ItemSrcExtractor.pickUp(workItem, ".*?src=\"(.*?)\".*?", domain);
        }
        return workItem;
    }

    private static String pickUp(String workItem, String regexPattern, String domain) {
        String value = RegexUtil.group(regexPattern, workItem, 1);
        if (Validator.isNullOrEmpty(value)) {
            return "";
        }
        if ((value = value.trim()).startsWith(domain)) {
            value = StringUtils.substringAfter(value, domain);
        }
        if (value.contains("?")) {
            value = StringUtils.substringBefore(value, "?");
        }
        if (Validator.isNotNullOrEmpty(domain) && value.startsWith("/")) {
            return StringUtil.substring(value, 1);
        }
        return value;
    }
}

