/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.httpconcat.builder;

import com.feilong.core.Validator;
import com.feilong.taglib.display.httpconcat.builder.HttpConcatGlobalConfigBuilder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainRebuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainRebuilder.class);

    private DomainRebuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String rebuild(String domain, HttpServletRequest request) {
        if (Validator.isNotNullOrEmpty(domain)) {
            return domain;
        }
        String globalDomain = HttpConcatGlobalConfigBuilder.GLOBAL_CONFIG.getDomain();
        if (Validator.isNullOrEmpty(globalDomain)) {
            String contextPath = request.getContextPath();
            LOGGER.debug("domain is null or empty, use request contextPath:[{}]", (Object)contextPath);
            return contextPath;
        }
        LOGGER.trace("domain is null or empty, use globalDomain:[{}]", (Object)globalDomain);
        return globalDomain;
    }
}

