/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http.listener;

import com.feilong.json.JsonUtil;
import com.feilong.servlet.ServletContextUtil;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextLoggingListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletContextLoggingListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if (LOGGER.isInfoEnabled()) {
            ServletContext servletContext = servletContextEvent.getServletContext();
            LOGGER.info("servletContext [Initialized],base info:[{}],[attribute] info:[{}],[initParameter] info:[{}]", new Object[]{JsonUtil.format(ServletContextUtil.getServletContextInfoMapForLog(servletContext)), JsonUtil.formatSimpleMap(ServletContextUtil.getAttributeMap(servletContext)), JsonUtil.format(ServletContextUtil.getInitParameterMap(servletContext))});
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (LOGGER.isInfoEnabled()) {
            ServletContext servletContext = servletContextEvent.getServletContext();
            LOGGER.info("servletContext [Destroyed] info:[{}] ", (Object)JsonUtil.format(ServletContextUtil.getServletContextInfoMapForLog(servletContext)));
        }
    }
}

