/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail.builder.setter;

import com.feilong.core.DefaultRuntimeException;
import com.feilong.core.Validator;
import com.feilong.lib.lang3.ArrayUtils;
import com.feilong.net.mail.entity.MailSendRequest;
import com.feilong.net.mail.util.InternetAddressUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import javax.mail.Message;
import javax.mail.MessagingException;

public final class RecipientsSetter {
    private RecipientsSetter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void setRecipients(Message message, MailSendRequest mailSendRequest) {
        RecipientsSetter.set(message, Message.RecipientType.TO, mailSendRequest.getTos());
        String[] cc = RecipientsSetter.buildCC(mailSendRequest.getCcs(), mailSendRequest.getFromAddress(), mailSendRequest.getIsDefaultCcSelf());
        RecipientsSetter.set(message, Message.RecipientType.CC, cc);
        RecipientsSetter.set(message, Message.RecipientType.BCC, mailSendRequest.getBccs());
    }

    private static String[] buildCC(String[] ccs, String fromAddress, boolean isDefaultCcSelf) {
        if (!isDefaultCcSelf) {
            return ccs;
        }
        if (ArrayUtils.contains(ccs, fromAddress)) {
            return ccs;
        }
        return ArrayUtils.add(ccs, fromAddress);
    }

    private static void set(Message message, Message.RecipientType recipientType, String[] addressArray) {
        try {
            if (Validator.isNotNullOrEmpty(addressArray)) {
                message.setRecipients(recipientType, InternetAddressUtil.toAddressArray(addressArray));
            }
        }
        catch (MessagingException e) {
            throw new DefaultRuntimeException(Slf4jUtil.format("addressArray:[{}],recipientType:[{}]", addressArray, recipientType), e);
        }
    }
}

