/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail.builder.setter;

import com.feilong.net.mail.FeiLongMailVersion;
import com.feilong.net.mail.entity.MailSendRequest;
import com.feilong.net.mail.entity.Priority;
import javax.mail.Message;
import javax.mail.MessagingException;

public class HeaderSetter {
    private static final String DISPOSITION_NOTIFICATION_TO = "Disposition-Notification-To";
    private static final String X_PRIORITY = "X-Priority";
    private static final String X_MAILER = "X-mailer";
    private static final String X_MAILER_VALUE = "FeiLong Mail Api " + FeiLongMailVersion.getVersion();

    private HeaderSetter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void setHeaders(Message message, MailSendRequest mailSendRequest) throws MessagingException {
        Priority priority = mailSendRequest.getPriority();
        if (null != priority) {
            message.addHeader(X_PRIORITY, priority.getLevelValue());
        }
        if (mailSendRequest.getIsNeedReturnReceipt()) {
            message.setHeader(DISPOSITION_NOTIFICATION_TO, "1");
        }
        message.setHeader(X_MAILER, X_MAILER_VALUE);
    }
}

