/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail;

import com.feilong.core.Validate;
import com.feilong.json.JsonUtil;
import com.feilong.net.mail.MailSender;
import com.feilong.net.mail.builder.MessageBuilder;
import com.feilong.net.mail.entity.MailSendConnectionConfig;
import com.feilong.net.mail.entity.MailSendRequest;
import com.feilong.net.mail.util.MessageSendUtil;
import javax.mail.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMailSender
implements MailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMailSender.class);
    private MailSendConnectionConfig mailSendConnectionConfig;

    public DefaultMailSender() {
    }

    public DefaultMailSender(MailSendConnectionConfig mailSendConnectionConfig) {
        this.mailSendConnectionConfig = mailSendConnectionConfig;
    }

    @Override
    public void send(MailSendRequest mailSendRequest) {
        Validate.notNull(mailSendRequest, "mailSenderConfig can't be null!", new Object[0]);
        Validate.notBlank(this.mailSendConnectionConfig.getUserName(), "mailSenderConfig.getUserName() can't be null!", new Object[0]);
        Validate.notBlank(this.mailSendConnectionConfig.getPassword(), "mailSenderConfig.getPassword() can't be null!", new Object[0]);
        Validate.notEmpty(mailSendRequest.getTos(), "mailSenderConfig.getTos() can't be null!", new Object[0]);
        Validate.notBlank(mailSendRequest.getFromAddress(), "mailSenderConfig.getFromAddress() can't be null!", new Object[0]);
        Validate.notBlank(mailSendRequest.getSubject(), "mailSenderConfig.getSubject() can't be null!", new Object[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("mailSenderConfig:{},mailSendConnectionConfig:[{}]", (Object)JsonUtil.format(mailSendRequest), (Object)JsonUtil.format(this.mailSendConnectionConfig));
        }
        Message message = MessageBuilder.build(mailSendRequest, this.mailSendConnectionConfig);
        MessageSendUtil.send(message);
    }

    public void setMailSendConnectionConfig(MailSendConnectionConfig mailSendConnectionConfig) {
        this.mailSendConnectionConfig = mailSendConnectionConfig;
    }
}

