/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.builder.httpurirequest;

import com.feilong.core.CharsetType;
import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import com.feilong.net.UncheckedHttpException;
import com.feilong.net.http.HttpRequest;
import com.feilong.net.http.builder.httpurirequest.NameValuePairBuilder;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.StringEntity;

final class HttpEntityBuilder {
    private HttpEntityBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static HttpEntity build(HttpRequest httpRequest) {
        String requestBody = httpRequest.getRequestBody();
        if (Validator.isNotNullOrEmpty(requestBody)) {
            return new StringEntity(requestBody, CharsetType.UTF8);
        }
        return HttpEntityBuilder.buildFormHttpEntity(httpRequest.getParamMap());
    }

    private static HttpEntity buildFormHttpEntity(Map<String, String> paramMap) {
        if (Validator.isNullOrEmpty(paramMap)) {
            return null;
        }
        List<NameValuePair> nameValuePairList = NameValuePairBuilder.build(paramMap);
        try {
            return new UrlEncodedFormEntity(nameValuePairList, CharsetType.UTF8);
        }
        catch (UnsupportedEncodingException e) {
            String message = Slf4jUtil.format("paramMap:[{}]", JsonUtil.format(paramMap));
            throw new UncheckedHttpException(message, e);
        }
    }
}

