/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.builder;

import com.feilong.core.Validate;
import com.feilong.json.JsonUtil;
import com.feilong.net.http.ConnectionConfig;
import com.feilong.net.http.HttpRequest;
import com.feilong.net.http.builder.httpurirequest.HttpUriRequestFactory;
import com.feilong.net.http.packer.HttpRequestHeadersPacker;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUriRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUriRequestBuilder.class);

    private HttpUriRequestBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static HttpUriRequest build(HttpRequest httpRequest, ConnectionConfig connectionConfig) {
        Validate.notNull(httpRequest, "httpRequest can't be null!", new Object[0]);
        String uri = httpRequest.getUri();
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("httpRequest info:[{}],connectionConfig:[{}]", (Object)JsonUtil.format(httpRequest), (Object)JsonUtil.format(connectionConfig));
        }
        HttpUriRequest httpUriRequest = HttpUriRequestFactory.create(httpRequest, connectionConfig);
        HttpRequestHeadersPacker.setHeaders(httpUriRequest, httpRequest.getHeaderMap(), connectionConfig);
        return httpUriRequest;
    }
}

