/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http;

import com.feilong.core.CharsetType;
import com.feilong.core.Validator;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.net.ParamUtil;
import com.feilong.net.http.HttpMethodType;
import java.util.Map;

public class HttpRequest {
    public static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.21 (KHTML, like Gecko) Chrome/19.0.1042.0 Safari/535.21";
    private String uri;
    private HttpMethodType httpMethodType = HttpMethodType.GET;
    private Map<String, String> paramMap;
    private Map<String, String> headerMap;
    private String requestBody;

    public HttpRequest() {
    }

    public HttpRequest(String uri) {
        this.uri = uri;
    }

    public HttpRequest(String uri, HttpMethodType httpMethodType) {
        this.uri = uri;
        this.httpMethodType = httpMethodType;
    }

    public HttpRequest(String uri, Map<String, String> paramMap, HttpMethodType httpMethodType) {
        this.uri = uri;
        this.paramMap = paramMap;
        this.httpMethodType = httpMethodType;
    }

    public HttpRequest(String uri, Map<String, String> paramMap, String httpMethodType) {
        this.uri = uri;
        this.paramMap = paramMap;
        this.httpMethodType = HttpMethodType.getByMethodValueIgnoreCase(httpMethodType);
    }

    public String getFullEncodedUrl() {
        return ParamUtil.addParameterSingleValueMap(this.getUri(), this.paramMap, CharsetType.UTF8);
    }

    public String getUri() {
        if (Validator.isNullOrEmpty(this.uri)) {
            return "";
        }
        if (this.uri.contains(" ")) {
            this.uri = StringUtil.replace(this.uri, " ", "%20");
        }
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public HttpMethodType getHttpMethodType() {
        return this.httpMethodType;
    }

    public void setHttpMethodType(HttpMethodType httpMethodType) {
        this.httpMethodType = httpMethodType;
    }

    public Map<String, String> getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(Map<String, String> paramMap) {
        this.paramMap = paramMap;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }
}

