/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.filetransfer.sftp;

import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.io.FileUtil;
import com.feilong.io.entity.FileInfoEntity;
import com.feilong.io.entity.FileType;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.net.filetransfer.AbstractFileTransfer;
import com.feilong.net.filetransfer.FileTransferException;
import com.feilong.net.filetransfer.sftp.SFTPFileTransferConfig;
import com.feilong.net.filetransfer.sftp.SFTPUtil;
import com.feilong.net.filetransfer.sftp.SftpSessionUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPFileTransfer
extends AbstractFileTransfer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SFTPFileTransfer.class);
    private SFTPFileTransferConfig sftpFileTransferConfig;
    private ChannelSftp channelSftp;
    private Session session;
    private static final String TYPE_SFTP = "sftp";

    @Override
    protected boolean connect() {
        if (this.channelSftp != null) {
            LOGGER.warn("channelSftp is not null,will disconnect first....");
            this.disconnect();
        }
        try {
            this.session = SFTPUtil.connectSession(this.sftpFileTransferConfig);
            LOGGER.trace("open [{}] session channel...", (Object)TYPE_SFTP);
            this.channelSftp = (ChannelSftp)this.session.openChannel(TYPE_SFTP);
            LOGGER.trace("channel connecting...");
            this.channelSftp.connect();
            boolean isSuccess = this.channelSftp.isConnected();
            this.logAfterConnected(isSuccess, this.session);
            return isSuccess;
        }
        catch (Exception e) {
            String message = Slf4jUtil.format("sftpFileTransferConfig:{}", JsonUtil.format(this.sftpFileTransferConfig));
            throw new FileTransferException(message, e);
        }
    }

    private void logAfterConnected(boolean isSuccess, Session session) {
        if (LOGGER.isInfoEnabled()) {
            String buildSessionPrettyString = SftpSessionUtil.buildSessionPrettyString(session);
            String sessionInfo = JsonUtil.format(SftpSessionUtil.getMapForLog(session));
            String pattern = "connect [{}]--------[{}]{}";
            this.logInfoOrError(isSuccess, pattern, buildSessionPrettyString, this.buildResultString(isSuccess), sessionInfo);
        }
    }

    @Override
    protected void disconnect() {
        if (this.channelSftp != null) {
            this.channelSftp.exit();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(StringUtils.center("channelSftp exit", 50, "------"));
            }
        }
        if (this.session != null) {
            String buildSessionPrettyString = SftpSessionUtil.buildSessionPrettyString(this.session);
            this.session.disconnect();
            if (LOGGER.isInfoEnabled()) {
                String message = Slf4jUtil.format(" session disconnect: [{}]", buildSessionPrettyString);
                LOGGER.info(StringUtils.center(message, 50, "------"));
            }
        }
        this.channelSftp = null;
    }

    @Override
    protected Map<String, FileInfoEntity> getLsFileMap(String remotePath) {
        Map<String, FileInfoEntity> map = MapUtil.newHashMap();
        try {
            Vector lsEntryList = this.channelSftp.ls(remotePath);
            for (int i = 0; i < lsEntryList.size(); ++i) {
                ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)lsEntryList.get(i);
                String fileName = lsEntry.getFilename();
                if (".".equals(fileName) || "..".equals(fileName)) continue;
                map.put(fileName, this.buildFileInfoEntity(remotePath, fileName, lsEntry.getAttrs()));
            }
            return map;
        }
        catch (SftpException e) {
            String message = Slf4jUtil.format("remotePath:[{}]", remotePath);
            throw new FileTransferException(message, e);
        }
    }

    private FileInfoEntity buildFileInfoEntity(String remotePath, String fileName, SftpATTRS attrs) {
        boolean isDirectory = this.isDirectory(remotePath + "/" + fileName);
        LOGGER.debug("fileName:{}", (Object)fileName);
        FileInfoEntity fileInfoEntity = new FileInfoEntity();
        fileInfoEntity.setFileType(isDirectory ? FileType.DIRECTORY : FileType.FILE);
        fileInfoEntity.setName(fileName);
        fileInfoEntity.setSize(attrs.getSize());
        fileInfoEntity.setLastModified(ConvertUtil.toLong(attrs.getMTime()));
        return fileInfoEntity;
    }

    @Override
    protected boolean mkdir(String remoteDirectory) {
        try {
            LOGGER.debug("begin mkdir:[{}]~~", (Object)remoteDirectory);
            this.channelSftp.mkdir(remoteDirectory);
            LOGGER.debug("mkdir:[{}] over~~", (Object)remoteDirectory);
            return true;
        }
        catch (SftpException e) {
            String message = Slf4jUtil.format("can't mkdir,remoteDirectory:[{}]", remoteDirectory);
            throw new FileTransferException(message, e);
        }
    }

    @Override
    protected void tryCd(String remoteDirectory) throws Exception {
        LOGGER.debug("cd:[{}]", (Object)remoteDirectory);
        this.channelSftp.cd(remoteDirectory);
    }

    @Override
    protected boolean upload(FileInputStream fileInputStream, String toFileName) {
        try {
            this.channelSftp.put((InputStream)fileInputStream, toFileName);
            return true;
        }
        catch (SftpException e) {
            String message = Slf4jUtil.format("can't upload fileInputStream,toFileName:[{}]", toFileName);
            throw new FileTransferException(message, e);
        }
    }

    @Override
    protected boolean isDirectory(String remoteFile) {
        try {
            SftpATTRS sftpATTRS = this.channelSftp.stat(remoteFile);
            boolean isDir = sftpATTRS.isDir();
            LOGGER.debug("remoteFile:[{}] is [{}]", (Object)remoteFile, (Object)(isDir ? "directory" : "file"));
            return isDir;
        }
        catch (SftpException e) {
            String message = Slf4jUtil.format("remoteFile:[{}] ", remoteFile);
            throw new FileTransferException(message, e);
        }
    }

    @Override
    protected boolean rmdir(String remotePath) {
        try {
            this.channelSftp.rmdir(remotePath);
            return true;
        }
        catch (SftpException e) {
            String message = Slf4jUtil.format("remotePath:[{}]", remotePath);
            throw new FileTransferException(message, e);
        }
    }

    @Override
    protected boolean rm(String remotePath) {
        try {
            this.channelSftp.rm(remotePath);
            return true;
        }
        catch (SftpException e) {
            String message = Slf4jUtil.format("remotePath:[{}]", remotePath);
            throw new FileTransferException(message, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean downRemoteSingleFile(String remoteSingleFile, String filePath) {
        try (FileOutputStream outputStream = FileUtil.getFileOutputStream(filePath);){
            this.channelSftp.get(remoteSingleFile, (OutputStream)outputStream);
            boolean bl = true;
            return bl;
        }
        catch (SftpException | IOException e) {
            String message = Slf4jUtil.format("remoteSingleFile:[{}],filePath:[{}]", remoteSingleFile, filePath);
            throw new FileTransferException(message, e);
        }
    }

    public void setSftpFileTransferConfig(SFTPFileTransferConfig sftpFileTransferConfig) {
        this.sftpFileTransferConfig = sftpFileTransferConfig;
    }
}

