/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.ezmorph.Morpher;
import com.feilong.lib.ezmorph.array.ObjectArrayMorpher;
import com.feilong.lib.ezmorph.bean.BeanMorpher;
import com.feilong.lib.ezmorph.object.IdentityObjectMorpher;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONArrayToBeanUtil;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.util.JSONUtils;
import com.feilong.lib.json.util.TargetClassFinder;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PropertyValueConvertUtil {
    private PropertyValueConvertUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static List toList(String key, Object value, JsonConfig jsonConfig, String name, Map<String, Class<?>> classMap) {
        Class<?> targetClass = TargetClassFinder.findTargetClass(key, classMap);
        targetClass = targetClass == null ? TargetClassFinder.findTargetClass(name, classMap) : targetClass;
        JsonConfig jsonConfigCopy = jsonConfig.copy();
        jsonConfigCopy.setRootClass(targetClass);
        jsonConfigCopy.setClassMap(classMap);
        return (List)JSONArrayToBeanUtil.toCollection((JSONArray)value, jsonConfigCopy);
    }

    static Collection toCollection(String key, Object value, JsonConfig jsonConfig, String name, Map<String, Class<?>> classMap, Class<?> collectionType) {
        Class<?> targetClass = TargetClassFinder.findTargetClass(key, classMap);
        targetClass = targetClass == null ? TargetClassFinder.findTargetClass(name, classMap) : targetClass;
        JsonConfig jsonConfigCopy = jsonConfig.copy();
        jsonConfigCopy.setRootClass(targetClass);
        jsonConfigCopy.setClassMap(classMap);
        jsonConfigCopy.setCollectionType(collectionType);
        return JSONArrayToBeanUtil.toCollection((JSONArray)value, jsonConfigCopy);
    }

    static Object toArray(String key, Object value, Class<?> targetType, JsonConfig jsonConfig, Map<String, Class<?>> classMap) {
        Class<?> innerType = JSONUtils.getInnerComponentType(targetType);
        Class<?> targetInnerType = TargetClassFinder.findTargetClass(key, classMap);
        if (innerType.equals(Object.class) && targetInnerType != null && !targetInnerType.equals(Object.class)) {
            innerType = targetInnerType;
        }
        JsonConfig jsonConfigCopy = jsonConfig.copy();
        jsonConfigCopy.setRootClass(innerType);
        jsonConfigCopy.setClassMap(classMap);
        Object array = JSONArrayToBeanUtil.toArray((JSONArray)value, jsonConfigCopy);
        if (innerType.isPrimitive() || JSONUtils.isNumber(innerType) || Boolean.class.isAssignableFrom(innerType) || JSONUtils.isString(innerType)) {
            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
        } else if (!array.getClass().equals(targetType) && !targetType.equals(Object.class)) {
            Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(Array.newInstance(innerType, 0).getClass());
            if (IdentityObjectMorpher.INSTANCE.equals(morpher)) {
                ObjectArrayMorpher beanMorpher = new ObjectArrayMorpher(new BeanMorpher(innerType, JSONUtils.getMorpherRegistry()));
                JSONUtils.getMorpherRegistry().registerMorpher(beanMorpher);
            }
            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
        }
        return array;
    }
}

