/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.processors.JsonVerifier;

public class JSONObjectSetValueCore {
    private JSONObjectSetValueCore() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void setValue(JSONObject jsonObject, String key, Object value, Class<?> type, JsonConfig jsonConfig, boolean bypass) {
        if (value == null && !JsonVerifier.isValidJsonValue(value = jsonConfig.findDefaultValueProcessor(type).getDefaultValue(type))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        boolean accumulated = false;
        if (jsonObject.properties.containsKey(key)) {
            if (String.class.isAssignableFrom(type)) {
                Object o = jsonObject.get(key);
                if (o instanceof JSONArray) {
                    ((JSONArray)o).addString((String)value);
                } else {
                    jsonObject.properties.put(key, new JSONArray().element(o).addString((String)value));
                }
            } else {
                jsonObject.accumulate(key, value, jsonConfig);
            }
            accumulated = true;
        } else if (bypass || String.class.isAssignableFrom(type)) {
            jsonObject.properties.put(key, value);
        } else {
            jsonObject.setInternal(key, value, jsonConfig);
        }
        value = jsonObject.get(key);
        if (accumulated) {
            JSONArray array = (JSONArray)value;
            value = array.get(array.size() - 1);
        }
    }
}

