/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.beanutils.DynaProperty;
import com.feilong.lib.json.BeanProcessing;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONFunction;
import com.feilong.lib.json.JSONNull;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JSONObjectSetValueCore;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.processors.JsonBeanProcessor;
import com.feilong.lib.json.processors.JsonValueProcessor;
import com.feilong.lib.json.processors.JsonVerifier;
import com.feilong.lib.json.util.CycleSetUtil;
import com.feilong.lib.json.util.JSONExceptionUtil;
import com.feilong.lib.json.util.JSONTokener;
import com.feilong.lib.json.util.JSONUtils;
import com.feilong.lib.json.util.PropertyFilter;
import com.feilong.lib.lang3.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;

class JSONObjectBuilder {
    private JSONObjectBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static JSONObject build(Object object, JsonConfig jsonConfig) {
        if (object == null || JSONUtils.isNull(object)) {
            return new JSONObject(true);
        }
        if (object instanceof JSONObject) {
            return JSONObjectBuilder._fromJSONObject((JSONObject)object, jsonConfig);
        }
        if (object instanceof DynaBean) {
            return JSONObjectBuilder._fromDynaBean((DynaBean)object, jsonConfig);
        }
        if (object instanceof JSONTokener) {
            return JSONObjectBuilder._fromJSONTokener((JSONTokener)object, jsonConfig);
        }
        if (object instanceof Map) {
            return JSONObjectBuilder._fromMap((Map)object, jsonConfig);
        }
        if (object instanceof String) {
            return JSONObjectBuilder._fromString((String)object, jsonConfig);
        }
        if (JSONUtils.isNumber(object) || JSONUtils.isBoolean(object) || JSONUtils.isString(object)) {
            return new JSONObject();
        }
        if (object instanceof Enum) {
            throw new JSONException("'object' is an Enum. Use JSONArray instead");
        }
        if (object instanceof Annotation || object.getClass().isAnnotation()) {
            throw new JSONException("'object' is an Annotation.");
        }
        if (JSONUtils.isArray(object)) {
            throw new JSONException("'object' is an array. Use JSONArray instead");
        }
        return JSONObjectBuilder._fromBean(object, jsonConfig);
    }

    private static JSONObject _fromString(String str, JsonConfig jsonConfig) {
        if (str == null || "null".equals(str)) {
            return new JSONObject(true);
        }
        return JSONObjectBuilder._fromJSONTokener(new JSONTokener(str), jsonConfig);
    }

    private static JSONObject _fromDynaBean(DynaBean bean, JsonConfig jsonConfig) {
        if (bean == null) {
            return new JSONObject(true);
        }
        if (!CycleSetUtil.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(bean);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONObject jsonObject = new JSONObject();
        try {
            DynaProperty[] props = bean.getDynaClass().getDynaProperties();
            Collection<String> exclusions = jsonConfig.getMergedExcludes();
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            for (int i = 0; i < props.length; ++i) {
                boolean bypass = false;
                DynaProperty dynaProperty = props[i];
                String key = dynaProperty.getName();
                if (exclusions.contains(key)) continue;
                Class<?> type = dynaProperty.getType();
                Object value = bean.get(dynaProperty.getName());
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(type, key);
                if (jsonValueProcessor != null) {
                    value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                    bypass = true;
                    if (!JsonVerifier.isValidJsonValue(value)) {
                        throw new JSONException("Value is not a valid JSON value. " + value);
                    }
                }
                JSONObjectSetValueCore.setValue(jsonObject, key, value, type, jsonConfig, bypass);
            }
        }
        catch (Exception e) {
            CycleSetUtil.removeInstance(bean);
            throw JSONExceptionUtil.build("", e);
        }
        CycleSetUtil.removeInstance(bean);
        return jsonObject;
    }

    static JSONObject _fromJSONTokener(JSONTokener tokener, JsonConfig jsonConfig) {
        if (tokener.matches("null.*")) {
            return new JSONObject(true);
        }
        if (tokener.nextClean() != '{') {
            throw tokener.syntaxError("A JSONObject text must begin with '{'");
        }
        Collection<String> exclusions = jsonConfig.getMergedExcludes();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        JSONObject jsonObject = new JSONObject();
        block14: while (true) {
            char peek;
            char c = tokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw tokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return jsonObject;
                }
            }
            tokener.back();
            String key = tokener.nextValue(jsonConfig).toString();
            c = tokener.nextClean();
            if (c == '=') {
                if (tokener.next() != '>') {
                    tokener.back();
                }
            } else if (c != ':') {
                throw tokener.syntaxError("Expected a ':' after a key");
            }
            boolean quoted = (peek = tokener.peek()) == '\"' || peek == '\'';
            Object v = tokener.nextValue(jsonConfig);
            if (quoted || !JSONUtils.isFunctionHeader(v)) {
                if (exclusions.contains(key)) {
                    switch (tokener.nextClean()) {
                        case ',': 
                        case ';': {
                            if (tokener.nextClean() == '}') {
                                return jsonObject;
                            }
                            tokener.back();
                            continue block14;
                        }
                        case '}': {
                            return jsonObject;
                        }
                    }
                    throw tokener.syntaxError("Expected a ',' or '}'");
                }
                if (jsonPropertyFilter == null || !jsonPropertyFilter.apply(tokener, key, v)) {
                    if (quoted && v instanceof String && (JSONUtils.mayBeJSON((String)v) || JSONUtils.isFunction(v))) {
                        v = "\"" + v + "\"";
                    }
                    if (jsonObject.properties.containsKey(key)) {
                        jsonObject.accumulate(key, v, jsonConfig);
                    } else {
                        jsonObject.element(key, v, jsonConfig);
                    }
                }
            } else {
                char ch;
                String params = JSONUtils.getFunctionParams((String)v);
                int i = 0;
                StringBuffer sb = new StringBuffer();
                while ((ch = tokener.next()) != '\u0000') {
                    if (ch == '{') {
                        ++i;
                    }
                    if (ch == '}') {
                        --i;
                    }
                    sb.append(ch);
                    if (i != 0) continue;
                    break;
                }
                if (i != 0) {
                    throw tokener.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                }
                String text = sb.toString();
                text = text.substring(1, text.length() - 1).trim();
                JSONFunction value = new JSONFunction(params != null ? StringUtils.split(params, ",") : null, text);
                if (jsonPropertyFilter == null || !jsonPropertyFilter.apply(tokener, key, value)) {
                    if (jsonObject.properties.containsKey(key)) {
                        jsonObject.accumulate(key, value, jsonConfig);
                    } else {
                        jsonObject.element(key, value, jsonConfig);
                    }
                }
            }
            switch (tokener.nextClean()) {
                case ',': 
                case ';': {
                    if (tokener.nextClean() == '}') {
                        return jsonObject;
                    }
                    tokener.back();
                    continue block14;
                }
                case '}': {
                    return jsonObject;
                }
            }
            break;
        }
        throw tokener.syntaxError("Expected a ',' or '}'");
    }

    private static JSONObject _fromMap(Map map, JsonConfig jsonConfig) {
        if (map == null) {
            return new JSONObject(true);
        }
        if (!CycleSetUtil.addInstance(map)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(map);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(map);
                throw JSONExceptionUtil.build("", e);
            }
        }
        Collection<String> exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        try {
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                boolean bypass = false;
                Map.Entry entry = entries.next();
                Object k = entry.getKey();
                if (k == null) {
                    throw new JSONException("JSON keys cannot be null.");
                }
                String key = String.valueOf(k);
                if ("null".equals(key)) {
                    throw new NullPointerException("JSON keys must not be null nor the 'null' string.");
                }
                if (exclusions.contains(key)) continue;
                Object value = entry.getValue();
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(map, key, value)) continue;
                if (value != null) {
                    JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(value.getClass(), key);
                    if (jsonValueProcessor != null) {
                        value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                        bypass = true;
                        if (!JsonVerifier.isValidJsonValue(value)) {
                            throw new JSONException("Value is not a valid JSON value. " + value);
                        }
                    }
                    JSONObjectSetValueCore.setValue(jsonObject, key, value, value.getClass(), jsonConfig, bypass);
                    continue;
                }
                if (jsonObject.properties.containsKey(key)) {
                    jsonObject.accumulate(key, JSONNull.getInstance(), new JsonConfig());
                    continue;
                }
                jsonObject.element(key, JSONNull.getInstance(), new JsonConfig());
            }
        }
        catch (Exception e) {
            CycleSetUtil.removeInstance(map);
            throw JSONExceptionUtil.build("", e);
        }
        CycleSetUtil.removeInstance(map);
        return jsonObject;
    }

    private static JSONObject _fromBean(Object bean, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(bean);
                throw JSONExceptionUtil.build("", e);
            }
        }
        Class<?> beanClass = bean.getClass();
        JsonBeanProcessor processor = jsonConfig.findJsonBeanProcessor(beanClass);
        if (processor != null) {
            JSONObject json = null;
            try {
                json = processor.processBean(bean, jsonConfig);
                if (json == null && (json = (JSONObject)jsonConfig.findDefaultValueProcessor(beanClass).getDefaultValue(beanClass)) == null) {
                    json = new JSONObject(true);
                }
                CycleSetUtil.removeInstance(bean);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(bean);
                throw JSONExceptionUtil.build("", e);
            }
            return json;
        }
        JSONObject jsonObject = BeanProcessing.defaultBeanProcessing(bean, jsonConfig);
        CycleSetUtil.removeInstance(bean);
        return jsonObject;
    }

    private static JSONObject _fromJSONObject(JSONObject object, JsonConfig jsonConfig) {
        if (object == null || object.isNullObject()) {
            return new JSONObject(true);
        }
        if (!CycleSetUtil.addInstance(object)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(object);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(object);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray sa = object.names(jsonConfig);
        Collection<String> exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        Iterator i = sa.iterator();
        while (i.hasNext()) {
            Object k = i.next();
            if (k == null) {
                throw new JSONException("JSON keys cannot be null.");
            }
            String key = String.valueOf(k);
            if ("null".equals(key)) {
                throw new NullPointerException("JSON keys must not be null nor the 'null' string.");
            }
            if (exclusions.contains(key)) continue;
            Object value = object.get(key);
            if (jsonPropertyFilter != null && jsonPropertyFilter.apply(object, key, value)) continue;
            if (jsonObject.properties.containsKey(key)) {
                jsonObject.accumulate(key, value, jsonConfig);
                continue;
            }
            jsonObject.setInternal(key, value, jsonConfig);
        }
        CycleSetUtil.removeInstance(object);
        return jsonObject;
    }
}

