/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.primitive;

import com.feilong.lib.ezmorph.IntegerValueUtil;
import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.primitive.AbstractPrimitiveMorpher;

public final class LongMorpher
extends AbstractPrimitiveMorpher<Long> {
    public LongMorpher() {
    }

    public LongMorpher(long defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public long morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return (Long)this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong(IntegerValueUtil.getIntegerValue(value));
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return (Long)this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class<?> morphsTo() {
        return Long.TYPE;
    }
}

