/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.DoubleMorpher;
import java.lang.reflect.Array;

public final class DoubleArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> DOUBLE_ARRAY_CLASS = double[].class;
    private double defaultValue;

    public DoubleArrayMorpher() {
        super(false);
    }

    public DoubleArrayMorpher(double defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (DOUBLE_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            DoubleMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = DoubleArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Double.TYPE, dimensions);
            DoubleMorpher doubleMorpher = morpher = this.isUseDefault() ? new DoubleMorpher(this.defaultValue) : new DoubleMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return DOUBLE_ARRAY_CLASS;
    }
}

