/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.excel.convertor;

import com.feilong.excel.ExcelException;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.excel.util.Config;
import com.feilong.lib.excel.convertor.AbstractDataConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;

public class DateConvertor
extends AbstractDataConvertor<Date> {
    private static final int WRONG_DATA_TYPE_DATE = 13;
    private String datePattern = Config.get("date.pattern");

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    @Override
    protected Date handleConvert(Object value, int sheetNo, String cellIndex, ExcelCell excelCell) {
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0) {
                if (excelCell.isMandatory()) {
                    throw new ExcelException(1, sheetNo, cellIndex, value, excelCell);
                }
                return null;
            }
            String pattern = excelCell.getPattern() == null ? this.datePattern : excelCell.getPattern();
            try {
                SimpleDateFormat df = new SimpleDateFormat(pattern);
                return df.parse((String)value);
            }
            catch (ParseException e) {
                throw new ExcelException(13, sheetNo, cellIndex, value, excelCell);
            }
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Double) {
            return DateUtil.getJavaDate((double)((Double)value));
        }
        throw new ExcelException(11, sheetNo, cellIndex, value, excelCell);
    }

    @Override
    public String getDataTypeAbbr() {
        return "date";
    }

    @Override
    public Class<Date> supportClass() {
        return Date.class;
    }
}

