/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.collection4;

import com.feilong.lib.collection4.TransformerUtils;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import org.apache.commons.collections4.Transformer;

public class MapUtils {
    private static final String INDENT_STRING = "    ";

    private MapUtils() {
    }

    public static <K, V> V getObject(Map<? super K, V> map, K key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static <K, V> Properties toProperties(Map<K, V> map) {
        Properties answer = new Properties();
        if (map != null) {
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry2;
                Map.Entry<K, V> entry = entry2 = iterator.next();
                K key = entry.getKey();
                V value = entry.getValue();
                answer.put((Object)key, (Object)value);
            }
        }
        return answer;
    }

    public static Map<String, Object> toMap(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            Object value = resourceBundle.getObject(key);
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> Map<V, K> invertMap(Map<K, V> map) {
        HashMap<V, K> out = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            out.put(entry.getValue(), entry.getKey());
        }
        return out;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtils.isEmpty(map);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> map) {
        return Collections.synchronizedMap(map);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> map) {
        return Collections.synchronizedSortedMap(map);
    }

    public static <K, V> void populateMap(Map<K, V> map, Iterable<? extends V> elements, Transformer<V, K> keyTransformer) {
        MapUtils.populateMap(map, elements, keyTransformer, TransformerUtils.nopTransformer());
    }

    public static <K, V, E> void populateMap(Map<K, V> map, Iterable<? extends E> elements, Transformer<E, K> keyTransformer, Transformer<E, V> valueTransformer) {
        for (E temp : elements) {
            map.put(keyTransformer.transform(temp), valueTransformer.transform(temp));
        }
    }

    public static int size(Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }
}

