/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.json.processor;

import com.feilong.core.Validate;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.json.processor.AbstractJsonValueProcessor;
import com.feilong.lib.json.JsonConfig;

public class StringOverLengthJsonValueProcessor
extends AbstractJsonValueProcessor {
    private static final String DEFAULT_OVERLENGTH_MASKSTRING = "......";
    private int maxLength = 500;
    private String overLengthMaskString = "......";

    public StringOverLengthJsonValueProcessor() {
    }

    public StringOverLengthJsonValueProcessor(int maxLength) {
        Validate.isTrue(maxLength > 0, "maxLength:[%s] must > 0", maxLength);
        this.maxLength = maxLength;
    }

    public StringOverLengthJsonValueProcessor(int maxLength, String overLengthMaskString) {
        Validate.isTrue(maxLength > 0, "maxLength:[%s] must > 0", maxLength);
        this.maxLength = maxLength;
        this.overLengthMaskString = overLengthMaskString;
    }

    @Override
    protected Object processValue(Object value, JsonConfig jsonConfig) {
        return StringOverLengthJsonValueProcessor.format(value, this.maxLength, this.overLengthMaskString);
    }

    public static Object format(Object value, int maxLength) {
        return StringOverLengthJsonValueProcessor.format(value, maxLength, DEFAULT_OVERLENGTH_MASKSTRING);
    }

    public static Object format(Object value, int maxLength, String overLengthMaskString) {
        if (null == value) {
            return "";
        }
        Validate.isTrue(maxLength > 0, "maxLength:[%s] must > 0", maxLength);
        String useOverLengthMaskString = ObjectUtil.defaultIfNull(overLengthMaskString, DEFAULT_OVERLENGTH_MASKSTRING);
        String string = value.toString();
        if (string.length() <= maxLength) {
            return string;
        }
        return StringUtil.substring(string, 0, maxLength) + useOverLengthMaskString;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getOverLengthMaskString() {
        return this.overLengthMaskString;
    }

    public void setOverLengthMaskString(String overLengthMaskString) {
        this.overLengthMaskString = overLengthMaskString;
    }
}

