/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.json.builder;

import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.json.JavaToJsonConfig;
import com.feilong.json.builder.JavaToJsonConfigBuilder;
import com.feilong.json.builder.JsonPropertyFilterBuilder;
import com.feilong.json.processor.CalendarJsonValueProcessor;
import com.feilong.json.processor.DateJsonValueProcessor;
import com.feilong.json.processor.SensitiveWordsJsonValueProcessor;
import com.feilong.json.processor.ToStringJsonValueProcessor;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.processors.JsonValueProcessor;
import com.feilong.lib.json.processors.PropertyNameProcessor;
import com.feilong.lib.json.util.PropertyFilter;
import com.feilong.lib.lang3.tuple.Pair;
import java.io.File;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;

public final class JsonConfigBuilder {
    private static final String[] SENSITIVE_WORDS_PROPERTY_NAMES = new String[]{"password", "key"};
    private static final Map<Class<?>, JsonValueProcessor> DEFAULT_CLASS_JSON_VALUE_PROCESSOR = ConvertUtil.toMapUseEntrys(Pair.of(Date.class, DateJsonValueProcessor.DEFAULT_INSTANCE), Pair.of(File.class, ToStringJsonValueProcessor.DEFAULT_INSTANCE), Pair.of(BigDecimal.class, ToStringJsonValueProcessor.DEFAULT_INSTANCE), Pair.of(XMLGregorianCalendar.class, ToStringJsonValueProcessor.DEFAULT_INSTANCE), Pair.of(Calendar.class, CalendarJsonValueProcessor.DEFAULT_INSTANCE));
    public static final JsonConfig DEFAULT_JAVA_TO_JSON_CONFIG = JsonConfigBuilder.buildDefaultJavaToJsonConfig();

    private JsonConfigBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static JsonConfig build(Object obj, JavaToJsonConfig javaToJsonConfig) {
        PropertyFilter propertyFilter;
        JavaToJsonConfig useJavaToJsonConfig = JavaToJsonConfigBuilder.buildUseJavaToJsonConfig(obj, javaToJsonConfig);
        if (null == useJavaToJsonConfig) {
            return DEFAULT_JAVA_TO_JSON_CONFIG;
        }
        JsonConfig jsonConfig = JsonConfigBuilder.buildDefaultJavaToJsonConfig();
        JsonConfigBuilder.registerJsonPropertyNameProcessor(useJavaToJsonConfig, jsonConfig);
        JsonConfigBuilder.registerJsonValueProcessor(useJavaToJsonConfig, jsonConfig);
        String[] excludes = useJavaToJsonConfig.getExcludes();
        if (Validator.isNotNullOrEmpty(excludes)) {
            jsonConfig.setExcludes(excludes);
        }
        if (null != (propertyFilter = JsonPropertyFilterBuilder.build(useJavaToJsonConfig))) {
            jsonConfig.setJsonPropertyFilter(propertyFilter);
        }
        if (useJavaToJsonConfig.getIsMaskDefaultSensitiveWords()) {
            JsonConfigBuilder.registerDefaultJsonValueProcessor(jsonConfig);
        }
        return jsonConfig;
    }

    private static void registerDefaultJsonValueProcessor(JsonConfig jsonConfig) {
        for (String propertyName : SENSITIVE_WORDS_PROPERTY_NAMES) {
            jsonConfig.registerJsonValueProcessor(propertyName, SensitiveWordsJsonValueProcessor.INSTANCE);
        }
    }

    private static void registerJsonValueProcessor(JavaToJsonConfig useJavaToJsonConfig, JsonConfig jsonConfig) {
        Map<String, JsonValueProcessor> propertyNameAndJsonValueProcessorMap = useJavaToJsonConfig.getPropertyNameAndJsonValueProcessorMap();
        if (Validator.isNotNullOrEmpty(propertyNameAndJsonValueProcessorMap)) {
            for (Map.Entry<String, JsonValueProcessor> entry : propertyNameAndJsonValueProcessorMap.entrySet()) {
                jsonConfig.registerJsonValueProcessor(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void registerJsonPropertyNameProcessor(JavaToJsonConfig useJavaToJsonConfig, JsonConfig jsonConfig) {
        Map<Class<?>, PropertyNameProcessor> targetClassAndPropertyNameProcessorMap = useJavaToJsonConfig.getJsonTargetClassAndPropertyNameProcessorMap();
        if (Validator.isNotNullOrEmpty(targetClassAndPropertyNameProcessorMap)) {
            for (Map.Entry<Class<?>, PropertyNameProcessor> entry : targetClassAndPropertyNameProcessorMap.entrySet()) {
                jsonConfig.registerJsonPropertyNameProcessor(entry.getKey(), entry.getValue());
            }
        }
    }

    static JsonConfig buildDefaultJavaToJsonConfig() {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setIgnoreDefaultExcludes(false);
        for (Map.Entry<Class<?>, JsonValueProcessor> entry : DEFAULT_CLASS_JSON_VALUE_PROCESSOR.entrySet()) {
            jsonConfig.registerJsonValueProcessor(entry.getKey(), entry.getValue());
        }
        return jsonConfig;
    }
}

