/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.json;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.ArrayUtil;
import com.feilong.core.lang.ClassUtil;
import com.feilong.core.lang.reflect.FieldUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.json.JavaToJsonConfig;
import com.feilong.json.JsonHelper;
import com.feilong.json.JsonToJavaConfig;
import com.feilong.json.JsonToJavaException;
import com.feilong.json.builder.JavaToJsonConfigBuilder;
import com.feilong.json.builder.JsonConfigBuilder;
import com.feilong.json.builder.JsonToJavaConfigBuilder;
import com.feilong.lib.ezmorph.MorpherRegistry;
import com.feilong.lib.ezmorph.object.DateMorpher;
import com.feilong.lib.json.JSON;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.util.JSONUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);

    private JsonUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String format(Object obj) {
        return JsonUtil.format(obj, (JavaToJsonConfig)null);
    }

    public static String format(Object obj, boolean isIgnoreNullValueElement) {
        return JsonUtil.format(obj, new JavaToJsonConfig(isIgnoreNullValueElement));
    }

    public static <K, V> String formatSimpleMap(Map<K, V> inputMap) {
        return null == inputMap ? "" : JsonUtil.formatSimpleMap(inputMap, new Class[]{null});
    }

    public static <K, V> String formatSimpleMap(Map<K, V> inputMap, Class<?> ... allowFormatClassTypes) {
        if (null == inputMap) {
            return "";
        }
        TreeMap<K, V> simpleMap = new TreeMap<K, V>();
        for (Map.Entry<K, V> entry : inputMap.entrySet()) {
            V value = entry.getValue();
            simpleMap.put(entry.getKey(), JsonHelper.isAllowFormatType(value, allowFormatClassTypes) ? value : String.valueOf(value));
        }
        return JsonUtil.format(simpleMap);
    }

    public static String format(Object obj, String[] excludes) {
        return JsonUtil.format(obj, excludes, 4, 4);
    }

    public static String format(Object obj, String[] excludes, int indentFactor, int indent) {
        return null == obj ? "" : JsonUtil.format(obj, JavaToJsonConfigBuilder.build(excludes, null), indentFactor, indent);
    }

    public static String formatWithIncludes(Object obj, String ... includes) {
        return null == obj ? "" : JsonUtil.format(obj, JavaToJsonConfigBuilder.build(null, includes));
    }

    public static String format(Object obj, int indentFactor, int indent) {
        return JsonUtil.format(obj, (JavaToJsonConfig)null, indentFactor, indent);
    }

    public static String format(Object obj, JavaToJsonConfig javaToJsonConfig) {
        return JsonUtil.format(obj, javaToJsonConfig, 4, 4);
    }

    public static String format(Object obj, JavaToJsonConfig javaToJsonConfig, int indentFactor, int indent) {
        if (null == obj) {
            return "";
        }
        if (JsonHelper.isCommonString(obj)) {
            return (String)obj;
        }
        JavaToJsonConfig useJavaToJsonConfig = JavaToJsonConfigBuilder.buildUseJavaToJsonConfig(obj, javaToJsonConfig);
        JsonConfig jsonConfig = JsonConfigBuilder.build(obj, useJavaToJsonConfig);
        JSON json = JsonHelper.toJSON(obj, jsonConfig);
        return json.toString(indentFactor, indent);
    }

    public static String formatObjectFieldsNameAndValueMap(Object obj) {
        return null == obj ? "" : JsonUtil.format(FieldUtil.getAllFieldNameAndValueMap(obj, new String[0]), JavaToJsonConfigBuilder.buildDefaultJavaToJsonConfig(obj));
    }

    public static <T> T[] toArray(Object json, JsonToJavaConfig jsonToJavaConfig) {
        if (null == json) {
            return null;
        }
        Validate.notNull(jsonToJavaConfig, "jsonToJavaConfig can't be null!", new Object[0]);
        Class<?> rootClass = jsonToJavaConfig.getRootClass();
        Validate.notNull(rootClass, "rootClass can't be null!", new Object[0]);
        try {
            JSONArray jsonArray = JsonHelper.toJSONArray(json, null);
            int size = jsonArray.size();
            ?[] t = ArrayUtil.newArray(rootClass, size);
            for (int i = 0; i < size; ++i) {
                t[i] = JsonUtil.toBean((Object)jsonArray.getJSONObject(i), jsonToJavaConfig);
            }
            return t;
        }
        catch (Exception e) {
            throw new JsonToJavaException(JsonUtil.buildJsonToJavaExceptionMessage(json, jsonToJavaConfig), e);
        }
    }

    public static <T> List<T> toList(Object json, Class<T> rootClass) {
        if (null == json) {
            return null;
        }
        Validate.notNull(rootClass, "rootClass can't be null!", new Object[0]);
        JsonToJavaConfig jsonToJavaConfig = new JsonToJavaConfig(rootClass);
        return JsonUtil.toList(json, jsonToJavaConfig);
    }

    public static <T> List<T> toList(Object json, JsonToJavaConfig jsonToJavaConfig) {
        if (null == json) {
            return null;
        }
        Validate.notNull(jsonToJavaConfig, "jsonToJavaConfig can't be null!", new Object[0]);
        Class<?> rootClass = jsonToJavaConfig.getRootClass();
        Validate.notNull(rootClass, "rootClass can't be null!", new Object[0]);
        try {
            JSONArray jsonArray = JsonHelper.toJSONArray(json, null);
            List<T> list = CollectionsUtil.newArrayList();
            int j = jsonArray.size();
            for (int i = 0; i < j; ++i) {
                list.add(JsonUtil.toBean((Object)jsonArray.getJSONObject(i), jsonToJavaConfig));
            }
            return list;
        }
        catch (Exception e) {
            throw new JsonToJavaException(JsonUtil.buildJsonToJavaExceptionMessage(json, jsonToJavaConfig), e);
        }
    }

    public static <T> Map<String, T> toMap(Object json) {
        return JsonUtil.toMap(json, null);
    }

    public static <T> Map<String, T> toMap(Object json, JsonToJavaConfig jsonToJavaConfig) {
        LOGGER.trace("input json:[{}],jsonToJavaConfig:[{}]", json, (Object)jsonToJavaConfig);
        if (Validator.isNullOrEmpty(json)) {
            return Collections.emptyMap();
        }
        if (ClassUtil.isInstance(json, String.class) && !JsonHelper.isKeyValueJsonString(json)) {
            throw new IllegalArgumentException("[" + json + "] can't convert to map");
        }
        Map map = MapUtil.newLinkedHashMap();
        try {
            JSONObject jsonObject = JsonHelper.toJSONObject(json, null);
            Iterator<String> keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                Object value = jsonObject.get(key);
                LOGGER.trace("key:[{}],value:[{}],value type is:[{}]", new Object[]{key, value, value.getClass().getName()});
                map.put(key, JsonHelper.transformerValue(value, jsonToJavaConfig));
            }
            return map;
        }
        catch (Exception e) {
            throw new JsonToJavaException(JsonUtil.buildJsonToJavaExceptionMessage(json, jsonToJavaConfig), e);
        }
    }

    public static <T> T toBean(Object json, Class<T> rootClass) {
        if (null == json) {
            return null;
        }
        Validate.notNull(rootClass, "rootClass can't be null!", new Object[0]);
        return JsonUtil.toBean(json, new JsonToJavaConfig(rootClass));
    }

    public static <T> T toBean(Object json, JsonToJavaConfig jsonToJavaConfig) {
        if (null == json) {
            return null;
        }
        Validate.notNull(jsonToJavaConfig, "jsonToJavaConfig can't be null!", new Object[0]);
        Class<?> rootClass = jsonToJavaConfig.getRootClass();
        Validate.notNull(rootClass, "rootClass can't be null!", new Object[0]);
        JsonConfig jsonConfig = JsonToJavaConfigBuilder.build(rootClass, jsonToJavaConfig);
        try {
            JSONObject jsonObject = JSONObject.fromObject(json);
            return (T)JSONObject.toBean(jsonObject, jsonConfig);
        }
        catch (Exception e) {
            throw new JsonToJavaException(JsonUtil.buildJsonToJavaExceptionMessage(json, jsonToJavaConfig), e);
        }
    }

    private static String buildJsonToJavaExceptionMessage(Object json, JsonToJavaConfig jsonToJavaConfig) {
        return Slf4jUtil.format("input json:[{}],jsonToJavaConfig:[{}]", json, JsonUtil.format(jsonToJavaConfig));
    }

    static {
        MorpherRegistry morpherRegistry = JSONUtils.getMorpherRegistry();
        morpherRegistry.registerMorpher(new DateMorpher(ConvertUtil.toArray("yyyy-MM-dd HH:mm:ss", "HH:mm:ss", "yyyy-MM-dd")));
    }
}

