/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.io;

import com.feilong.core.Validate;
import com.feilong.lib.io.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;

public final class ReaderUtil {
    private ReaderUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static StringReader newStringReader(String str) {
        Validate.notNull(str, "str can't be null!", new Object[0]);
        return new StringReader(str);
    }

    public static String toString(Reader reader) {
        Validate.notNull(reader, "reader can't be null!", new Object[0]);
        try {
            return IOUtils.toString(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readLine(Reader reader) {
        Validate.notNull(reader, "reader can't be null!", new Object[0]);
        try (BufferedReader bufferedReader = IOUtils.toBufferedReader(reader);){
            String string = bufferedReader.readLine();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

