/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.io;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.io.entity.FileType;
import com.feilong.io.entity.FileWriteMode;
import com.feilong.lib.io.FileUtils;
import com.feilong.lib.lang3.tuple.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    public static final Long ONE_KB = 1024L;
    public static final long ONE_MB = ONE_KB * ONE_KB;
    public static final long ONE_GB = ONE_KB * ONE_MB;
    public static final long ONE_TB = ONE_KB * ONE_GB;
    public static final int DEFAULT_BUFFER_LENGTH = (int)(10L * ONE_KB);
    private static final Map<Long, String> DIVISOR_AND_UNIT_MAP = ConvertUtil.toMapUseEntrys(Pair.of(ONE_TB, "TB"), Pair.of(ONE_GB, "GB"), Pair.of(ONE_MB, "MB"), Pair.of(ONE_KB, "KB"));

    private FileUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static byte[] toByteArray(String filePath) {
        Validate.notBlank(filePath, "filePath can't be blank!", new Object[0]);
        File file = new File(filePath);
        return FileUtil.toByteArray(file);
    }

    public static byte[] toByteArray(File file) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        try {
            return FileUtils.readFileToByteArray(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static FileOutputStream getFileOutputStream(String filePath) {
        Validate.notBlank(filePath, "filePath can't be blank!", new Object[0]);
        return FileUtil.getFileOutputStream(filePath, false);
    }

    public static FileOutputStream getFileOutputStream(String filePath, FileWriteMode fileWriteMode) {
        Validate.notBlank(filePath, "filePath can't be blank!", new Object[0]);
        Validate.notNull(fileWriteMode, "fileWriteMode can't be null!", new Object[0]);
        boolean append = fileWriteMode == FileWriteMode.APPEND;
        return FileUtil.getFileOutputStream(filePath, append);
    }

    static FileOutputStream getFileOutputStream(String filePath, boolean append) {
        Validate.notBlank(filePath, "filePath can't be blank!", new Object[0]);
        return FileUtil.getFileOutputStream(new File(filePath), append);
    }

    static FileOutputStream getFileOutputStream(File file, boolean append) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        try {
            return FileUtils.openOutputStream(file, append);
        }
        catch (IOException e) {
            throw new UncheckedIOException("file:[" + file + "],append:" + append, e);
        }
    }

    public static FileInputStream getFileInputStream(String filePath) {
        Validate.notBlank(filePath, "filePath can't be blank!", new Object[0]);
        return FileUtil.getFileInputStream(new File(filePath));
    }

    public static FileInputStream getFileInputStream(File file) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        try {
            return FileUtils.openInputStream(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isEmptyDirectory(String directory) {
        Validate.notBlank(directory, "directory can't be null/empty!", new Object[0]);
        File file = new File(directory);
        Validate.isTrue(file.exists(), "directory file " + directory + " don't exists!", new Object[0]);
        Validate.isTrue(file.isDirectory(), "directory file " + directory + " is not Directory!", new Object[0]);
        File[] listFiles = file.listFiles();
        int fileListLength = listFiles.length;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("file :[{}] list length:[{}]", (Object)directory, (Object)fileListLength);
            for (File tempFile : listFiles) {
                LOGGER.debug("[{}] [{}]", (Object)tempFile.getName(), (Object)(tempFile.isDirectory() ? FileType.DIRECTORY : FileType.FILE));
            }
        }
        return 0 == fileListLength;
    }

    public static void createDirectoryByFilePath(String filePath) {
        Validate.notBlank(filePath, "filePath can't be null/empty!", new Object[0]);
        String directory = FileUtil.getParent(filePath);
        FileUtil.createDirectory(directory);
    }

    public static void createDirectory(String directory) {
        Validate.notBlank(directory, "directory can't be null/empty!", new Object[0]);
        File directoryFile = new File(directory);
        boolean isExists = directoryFile.exists();
        if (isExists) {
            LOGGER.trace("directory:[{}] exists,don't need mkdirs,nothing to do~", (Object)directoryFile);
            return;
        }
        String absolutePath = directoryFile.getAbsolutePath();
        boolean flag = directoryFile.mkdirs();
        Validate.isTrue(flag, "could't create directory:[%s]", absolutePath);
        LOGGER.debug("success mkdirs:[{}]~~", (Object)absolutePath);
    }

    public static boolean deleteFileOrDirectory(String filePath) {
        Validate.notBlank(filePath, "filePath can't be blank!", new Object[0]);
        return FileUtil.deleteFileOrDirectory(new File(filePath));
    }

    public static boolean deleteFileOrDirectory(File file) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        return FileUtils.deleteQuietly(file);
    }

    public static String getParent(String filePath) {
        Validate.notBlank(filePath, "filePath can't be null/empty!", new Object[0]);
        File file = new File(filePath);
        return file.getParent();
    }

    public static boolean isExistFile(String filePath) {
        Validate.notBlank(filePath, "filePath can't be blank!", new Object[0]);
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean isNotExistFile(String filePath) {
        Validate.notBlank(filePath, "filePath can't be blank!", new Object[0]);
        return !FileUtil.isExistFile(filePath);
    }

    public static long getFileSize(File file) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        return FileUtils.sizeOf(file);
    }

    public static String getFileFormatSize(File file) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        long fileSize = FileUtil.getFileSize(file);
        return FileUtil.formatSize(fileSize);
    }

    public static String formatSize(long fileSize) {
        Validate.isTrue(fileSize >= 0L, "fileSize :[%s] must >=0", new Object[0]);
        if (fileSize < ONE_KB) {
            return fileSize + "Bytes";
        }
        for (Map.Entry<Long, String> entry : DIVISOR_AND_UNIT_MAP.entrySet()) {
            Long divisor = entry.getKey();
            String unit = entry.getValue();
            if (fileSize < divisor) continue;
            long remainder = 100L * (fileSize % divisor) / divisor;
            return fileSize / divisor + (0L == remainder ? "" : "." + remainder) + unit;
        }
        throw new UnsupportedOperationException("fileSize:[" + fileSize + "] not support!");
    }

    public static URL[] toURLs(List<String> filePathList) {
        Validate.notEmpty(filePathList, "filePathList can't be null/empty!", new Object[0]);
        String[] filePaths = ConvertUtil.toArray(filePathList, String.class);
        return FileUtil.toURLs(filePaths);
    }

    public static URL[] toURLs(String ... filePaths) {
        Validate.notEmpty(filePaths, "filePaths can't be null/empty!", new Object[0]);
        File[] files = ConvertUtil.toArray(filePaths, File.class);
        try {
            return FileUtils.toURLs(files);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

