/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.formatter.builder;

import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.lang.reflect.FieldUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.formatter.builder.AbstractFormatterBuilder;
import com.feilong.formatter.builder.BeanTypeFormatterColumnEntityBuilder;
import com.feilong.formatter.entity.BeanFormatterConfig;
import com.feilong.formatter.entity.FormatterColumnEntity;
import com.feilong.lib.lang3.ArrayUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class BeanTypeFormatterBuilder
extends AbstractFormatterBuilder {
    @Override
    public <T> Object[] buildLineData(T bean, List<String> propertyNameList, BeanFormatterConfig beanFormatterConfig) {
        if (Validator.isNullOrEmpty(bean)) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        Map<String, Object> propertyValueMap = MapUtil.newLinkedHashMap();
        PropertyUtil.copyProperties(propertyValueMap, bean, ConvertUtil.toStrings(propertyNameList));
        return BeanTypeFormatterBuilder.buildLineData(propertyValueMap, beanFormatterConfig);
    }

    @Override
    protected <T> List<FormatterColumnEntity> buildFormatterColumnEntityList(T bean, BeanFormatterConfig beanFormatterConfig) {
        Class<?> klass = bean.getClass();
        List<Field> fieldsList = FieldUtil.getAllFieldList(klass, beanFormatterConfig.getExcludePropertyNames());
        List<FormatterColumnEntity> list = CollectionsUtil.newArrayList();
        for (Field field : fieldsList) {
            list.add(BeanTypeFormatterColumnEntityBuilder.buildFormatterColumnEntity(field));
        }
        return list;
    }
}

